/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;

public class CommentsTable
extends POIXMLDocumentPart {
    private CTComments comments;
    private Map<String, CTComment> commentRefs;

    public CommentsTable() {
        this.comments = CTComments.Factory.newInstance();
        this.comments.addNewCommentList();
        this.comments.addNewAuthors().addAuthor("");
    }

    public CommentsTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            CommentsDocument doc = CommentsDocument.Factory.parse(is);
            this.comments = doc.getComments();
        }
        catch (XmlException e2) {
            throw new IOException(e2.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CommentsDocument doc = CommentsDocument.Factory.newInstance();
        doc.setComments(this.comments);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public void referenceUpdated(String oldReference, CTComment comment) {
        if (this.commentRefs != null) {
            this.commentRefs.remove(oldReference);
            this.commentRefs.put(comment.getRef(), comment);
        }
    }

    public int getNumberOfComments() {
        return this.comments.getCommentList().sizeOfCommentArray();
    }

    public int getNumberOfAuthors() {
        return this.comments.getAuthors().sizeOfAuthorArray();
    }

    public String getAuthor(long authorId) {
        return this.comments.getAuthors().getAuthorArray((int)authorId);
    }

    public int findAuthor(String author) {
        for (int i2 = 0; i2 < this.comments.getAuthors().sizeOfAuthorArray(); ++i2) {
            if (!this.comments.getAuthors().getAuthorArray(i2).equals(author)) continue;
            return i2;
        }
        return this.addNewAuthor(author);
    }

    public XSSFComment findCellComment(String cellRef) {
        CTComment ct = this.getCTComment(cellRef);
        return ct == null ? null : new XSSFComment(this, ct, null);
    }

    public CTComment getCTComment(String cellRef) {
        if (this.commentRefs == null) {
            this.commentRefs = new HashMap<String, CTComment>();
            for (CTComment comment : this.comments.getCommentList().getCommentArray()) {
                this.commentRefs.put(comment.getRef(), comment);
            }
        }
        return this.commentRefs.get(cellRef);
    }

    public CTComment newComment() {
        CTComment ct = this.comments.getCommentList().addNewComment();
        ct.setRef("A1");
        ct.setAuthorId(0L);
        if (this.commentRefs != null) {
            this.commentRefs.put(ct.getRef(), ct);
        }
        return ct;
    }

    public boolean removeComment(String cellRef) {
        CTCommentList lst = this.comments.getCommentList();
        if (lst != null) {
            for (int i2 = 0; i2 < lst.sizeOfCommentArray(); ++i2) {
                CTComment comment = lst.getCommentArray(i2);
                if (!cellRef.equals(comment.getRef())) continue;
                lst.removeComment(i2);
                if (this.commentRefs != null) {
                    this.commentRefs.remove(cellRef);
                }
                return true;
            }
        }
        return false;
    }

    private int addNewAuthor(String author) {
        int index = this.comments.getAuthors().sizeOfAuthorArray();
        this.comments.getAuthors().insertAuthor(index, author);
        return index;
    }

    public CTComments getCTComments() {
        return this.comments;
    }
}

