/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.ptg.AreaErrPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFRowShifter {
    private final XSSFSheet sheet;

    public XSSFRowShifter(XSSFSheet sh) {
        this.sheet = sh;
    }

    public List<CellRangeAddress> shiftMerged(int startRow, int endRow, int n2) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        for (int i2 = 0; i2 < this.sheet.getNumMergedRegions(); ++i2) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i2);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || XSSFRowShifter.containsCell(merged, startRow - 1, 0) || XSSFRowShifter.containsCell(merged, endRow + 1, 0)) continue;
            merged.setFirstRow(merged.getFirstRow() + n2);
            merged.setLastRow(merged.getLastRow() + n2);
            shiftedRegions.add(merged);
            this.sheet.removeMergedRegion(i2);
            --i2;
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    public void updateNamedRanges(FormulaShifter shifter) {
        XSSFWorkbook wb = this.sheet.getWorkbook();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        for (int i2 = 0; i2 < wb.getNumberOfNames(); ++i2) {
            int sheetIndex;
            XSSFName name = wb.getNameAt(i2);
            String formula = name.getRefersToFormula();
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, 4, sheetIndex = name.getSheetIndex());
            if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
            String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
            name.setRefersToFormula(shiftedFmla);
        }
    }

    public void updateFormulas(FormulaShifter shifter) {
        this.updateSheetFormulas(this.sheet, shifter);
        XSSFWorkbook wb = this.sheet.getWorkbook();
        for (XSSFSheet sh : wb) {
            if (this.sheet == sh) continue;
            this.updateSheetFormulas(sh, shifter);
        }
    }

    private void updateSheetFormulas(XSSFSheet sh, FormulaShifter shifter) {
        for (Row r2 : sh) {
            XSSFRow row = (XSSFRow)r2;
            this.updateRowFormulas(row, shifter);
        }
    }

    private void updateRowFormulas(XSSFRow row, FormulaShifter shifter) {
        for (Cell c2 : row) {
            String ref;
            String shiftedRef;
            String shiftedFormula;
            XSSFCell cell = (XSSFCell)c2;
            CTCell ctCell = cell.getCTCell();
            if (!ctCell.isSetF()) continue;
            CTCellFormula f2 = ctCell.getF();
            String formula = f2.getStringValue();
            if (formula.length() > 0 && (shiftedFormula = XSSFRowShifter.shiftFormula(row, formula, shifter)) != null) {
                f2.setStringValue(shiftedFormula);
            }
            if (!f2.isSetRef() || (shiftedRef = XSSFRowShifter.shiftFormula(row, ref = f2.getRef(), shifter)) == null) continue;
            f2.setRef(shiftedRef);
        }
    }

    private static String shiftFormula(XSSFRow row, String formula, FormulaShifter shifter) {
        XSSFSheet sheet = row.getSheet();
        XSSFWorkbook wb = sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        Ptg[] ptgs = FormulaParser.parse(formula, fpb, 0, sheetIndex);
        String shiftedFmla = null;
        if (shifter.adjustFormula(ptgs, sheetIndex)) {
            shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
        }
        return shiftedFmla;
    }

    public void updateConditionalFormatting(FormulaShifter shifter) {
        XSSFWorkbook wb = this.sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(this.sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        List<CTConditionalFormatting> cfList = this.sheet.getCTWorksheet().getConditionalFormattingList();
        for (int j2 = 0; j2 < cfList.size(); ++j2) {
            CTConditionalFormatting cf = cfList.get(j2);
            ArrayList<CellRangeAddress> cellRanges = new ArrayList<CellRangeAddress>();
            for (Object stRef : cf.getSqref()) {
                String[] regions = stRef.toString().split(" ");
                for (int i2 = 0; i2 < regions.length; ++i2) {
                    cellRanges.add(CellRangeAddress.valueOf(regions[i2]));
                }
            }
            boolean changed = false;
            ArrayList<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
            for (int i3 = 0; i3 < cellRanges.size(); ++i3) {
                CellRangeAddress craOld = (CellRangeAddress)cellRanges.get(i3);
                CellRangeAddress craNew = XSSFRowShifter.shiftRange(shifter, craOld, sheetIndex);
                if (craNew == null) {
                    changed = true;
                    continue;
                }
                temp.add(craNew);
                if (craNew == craOld) continue;
                changed = true;
            }
            if (changed) {
                int nRanges = temp.size();
                if (nRanges == 0) {
                    cfList.remove(j2);
                    continue;
                }
                ArrayList<String> refs = new ArrayList<String>();
                for (CellRangeAddress a2 : temp) {
                    refs.add(a2.formatAsString());
                }
                cf.setSqref(refs);
            }
            for (CTCfRule cfRule : cf.getCfRuleList()) {
                List<String> formulas = cfRule.getFormulaList();
                for (int i4 = 0; i4 < formulas.size(); ++i4) {
                    String formula = formulas.get(i4);
                    Ptg[] ptgs = FormulaParser.parse(formula, fpb, 0, sheetIndex);
                    if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
                    String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
                    formulas.set(i4, shiftedFmla);
                }
            }
        }
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

