/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr.treewalker;

import groovyjarjarantlr.collections.AST;
import java.io.PrintStream;
import java.util.Stack;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;

public class SourcePrinter
extends VisitorAdapter {
    private final String[] tokenNames;
    private int tabLevel;
    private int lastLinePrinted;
    private final boolean newLines;
    protected final PrintStream out;
    private String className;
    private final Stack stack;
    private int stringConstructorCounter;

    public SourcePrinter(PrintStream out, String[] tokenNames) {
        this(out, tokenNames, true);
    }

    public SourcePrinter(PrintStream out, String[] tokenNames, boolean newLines) {
        this.tokenNames = tokenNames;
        this.tabLevel = 0;
        this.lastLinePrinted = 0;
        this.out = out;
        this.newLines = newLines;
        this.stack = new Stack();
    }

    public void visitAbstract(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "abstract ", null, null);
    }

    public void visitAnnotation(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "@");
        }
        if (visit == 2) {
            this.print(t2, visit, "(");
        }
        if (visit == 3) {
            this.print(t2, visit, ", ");
        }
        if (visit == 4) {
            if (t2.getNumberOfChildren() > 1) {
                this.print(t2, visit, ") ");
            } else {
                this.print(t2, visit, " ");
            }
        }
    }

    public void visitAnnotations(GroovySourceAST t2, int visit) {
    }

    public void visitAnnotationDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "@interface ", null, null);
    }

    public void visitAnnotationFieldDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "() ", "default ", null);
    }

    public void visitAnnotationMemberValuePair(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " = ", null, null);
    }

    public void visitArrayDeclarator(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 12 || this.getParentNode().getType() == 22) {
            this.print(t2, visit, null, null, "[]");
        } else {
            this.print(t2, visit, "[", null, "]");
        }
    }

    public void visitAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " = ", null, null);
    }

    public void visitBand(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " & ", null, null);
    }

    public void visitBandAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " &= ", null, null);
    }

    public void visitBnot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "~", null, null);
    }

    public void visitBor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " | ", null, null);
    }

    public void visitBorAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " |= ", null, null);
    }

    public void visitBsr(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>> ", null, null);
    }

    public void visitBsrAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>>= ", null, null);
    }

    public void visitBxor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ^ ", null, null);
    }

    public void visitBxorAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ^= ", null, null);
    }

    public void visitCaseGroup(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
        }
        if (visit == 4) {
            --this.tabLevel;
        }
    }

    public void visitClassDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "class ", null, null);
        if (visit == 1) {
            this.className = t2.childOfType(86).getText();
        }
    }

    public void visitClosedBlock(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "{", "-> ", "}");
    }

    public void visitClosureList(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", "; ", ")");
    }

    public void visitCompareTo(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <=> ", null, null);
    }

    public void visitCtorCall(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "this(", " ", ")");
    }

    public void visitCtorIdent(GroovySourceAST t2, int visit) {
        this.print(t2, visit, this.className, null, null);
    }

    public void visitDec(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "--", null, null);
    }

    public void visitDiv(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " / ", null, null);
    }

    public void visitDivAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " /= ", null, null);
    }

    public void visitDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ".", null, null);
    }

    public void visitDynamicMember(GroovySourceAST t2, int visit) {
        if (t2.childOfType(47) == null) {
            this.printUpdatingTabLevel(t2, visit, "(", null, ")");
        }
    }

    public void visitElist(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 61) {
            this.print(t2, visit, "(", ", ", ")");
        } else {
            this.print(t2, visit, null, ", ", null);
        }
    }

    public void visitEnumConstantDef(GroovySourceAST t2, int visit) {
        GroovySourceAST sibling = (GroovySourceAST)t2.getNextSibling();
        if (sibling != null && sibling.getType() == 61) {
            this.print(t2, visit, null, null, ", ");
        }
    }

    public void visitEnumDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "enum ", null, null);
    }

    public void visitEqual(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " == ", null, null);
    }

    public void visitExpr(GroovySourceAST t2, int visit) {
    }

    public void visitExtendsClause(GroovySourceAST t2, int visit) {
        if (visit == 1 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " extends ");
        }
    }

    public void visitFinal(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "final ", null, null);
    }

    public void visitForCondition(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ; ", null, null);
    }

    public void visitForInit(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", null, null);
    }

    public void visitForInIterable(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "(", " in ", ") ");
    }

    public void visitForIterator(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ; ", null, ")");
    }

    public void visitGe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >= ", null, null);
    }

    public void visitGt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " > ", null, null);
    }

    public void visitIdent(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitImplementsClause(GroovySourceAST t2, int visit) {
        if (visit == 1 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " implements ");
        }
        if (visit == 4) {
            this.print(t2, visit, " ");
        }
    }

    public void visitImplicitParameters(GroovySourceAST t2, int visit) {
    }

    public void visitImport(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "import ", null, null);
    }

    public void visitInc(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "++", null, null);
    }

    public void visitIndexOp(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "[", null, "]");
    }

    public void visitInterfaceDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "interface ", null, null);
    }

    public void visitInstanceInit(GroovySourceAST t2, int visit) {
    }

    public void visitLabeledArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ":", null, null);
    }

    public void visitLabeledStat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ":", null, null);
    }

    public void visitLand(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " && ", null, null);
    }

    public void visitLe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <= ", null, null);
    }

    public void visitListConstructor(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "[", null, "]");
    }

    public void visitLiteralAs(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " as ", null, null);
    }

    public void visitLiteralAssert(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() > 1) {
            this.print(t2, visit, "assert ", null, " : ");
        } else {
            this.print(t2, visit, "assert ", null, null);
        }
    }

    public void visitLiteralBoolean(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "boolean", null, null);
    }

    public void visitLiteralBreak(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "break ", null, null);
    }

    public void visitLiteralByte(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "byte", null, null);
    }

    public void visitLiteralCase(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "case ", null, ":");
    }

    public void visitLiteralCatch(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, " catch (", null, ") ");
    }

    public void visitLiteralChar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "char", null, null);
    }

    public void visitLiteralContinue(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "continue ", null, null);
    }

    public void visitLiteralDefault(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "default", null, ":");
    }

    public void visitLiteralDouble(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "double", null, null);
    }

    public void visitLiteralFalse(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "false", null, null);
    }

    public void visitLiteralFinally(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "finally ", null, null);
    }

    public void visitLiteralFloat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "float", null, null);
    }

    public void visitLiteralFor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "for ", null, null);
    }

    public void visitLiteralIf(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "if (", " else ", ") ");
    }

    public void visitLiteralIn(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " in ", null, null);
    }

    public void visitLiteralInstanceof(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " instanceof ", null, null);
    }

    public void visitLiteralInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "int", null, null);
    }

    public void visitLiteralLong(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "long", null, null);
    }

    public void visitLiteralNative(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "native ", null, null);
    }

    public void visitLiteralNew(GroovySourceAST t2, int visit) {
        if (t2.childOfType(16) == null) {
            this.print(t2, visit, "new ", "(", ")");
        } else {
            this.print(t2, visit, "new ", null, null);
        }
    }

    public void visitLiteralNull(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "null", null, null);
    }

    public void visitLiteralPrivate(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "private ", null, null);
    }

    public void visitLiteralProtected(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "protected ", null, null);
    }

    public void visitLiteralPublic(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "public ", null, null);
    }

    public void visitLiteralReturn(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "return ", null, null);
    }

    public void visitLiteralShort(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "short", null, null);
    }

    public void visitLiteralStatic(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "static ", null, null);
    }

    public void visitLiteralSuper(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "super", null, null);
    }

    public void visitLiteralSwitch(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "switch (");
            ++this.tabLevel;
        }
        if (visit == 3) {
            this.print(t2, visit, ") {");
        }
        if (visit == 4) {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    public void visitLiteralSynchronized(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() > 0) {
            this.print(t2, visit, "synchronized (", null, ") ");
        } else {
            this.print(t2, visit, "synchronized ", null, null);
        }
    }

    public void visitLiteralThis(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "this", null, null);
    }

    public void visitLiteralThreadsafe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "threadsafe ", null, null);
    }

    public void visitLiteralThrow(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "throw ", null, null);
    }

    public void visitLiteralThrows(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "throws ", null, null);
    }

    public void visitLiteralTransient(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "transient ", null, null);
    }

    public void visitLiteralTrue(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "true", null, null);
    }

    public void visitLiteralTry(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "try ", null, null);
    }

    public void visitLiteralVoid(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "void", null, null);
    }

    public void visitLiteralVolatile(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "volatile ", null, null);
    }

    public void visitLiteralWhile(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "while (", null, ") ");
    }

    public void visitLnot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "!", null, null);
    }

    public void visitLor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " || ", null, null);
    }

    public void visitLt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " < ", null, null);
    }

    public void visitMapConstructor(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() == 0) {
            this.print(t2, visit, "[:]", null, null);
        } else {
            this.printUpdatingTabLevel(t2, visit, "[", null, "]");
        }
    }

    public void visitMemberPointer(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ".&", null, null);
    }

    public void visitMethodCall(GroovySourceAST t2, int visit) {
        if ("<command>".equals(t2.getText())) {
            this.printUpdatingTabLevel(t2, visit, " ", " ", null);
        } else {
            this.printUpdatingTabLevel(t2, visit, "(", " ", ")");
        }
    }

    public void visitMethodDef(GroovySourceAST t2, int visit) {
    }

    public void visitMinus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " - ", null, null);
    }

    public void visitMinusAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " -= ", null, null);
    }

    public void visitMod(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " % ", null, null);
    }

    public void visitModifiers(GroovySourceAST t2, int visit) {
    }

    public void visitModAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " %= ", null, null);
    }

    public void visitMultiCatch(GroovySourceAST t2, int visit) {
        if (visit == 4) {
            AST child = t2.getFirstChild();
            if ("MULTICATCH_TYPES".equals(child.getText())) {
                this.print(t2, visit, null, null, " " + child.getNextSibling().getText());
            } else {
                this.print(t2, visit, null, null, " " + child.getFirstChild().getText());
            }
        }
    }

    public void visitMultiCatchTypes(GroovySourceAST t2, int visit) {
    }

    public void visitNotEqual(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " != ", null, null);
    }

    public void visitNumBigDecimal(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitNumBigInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitNumDouble(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitNumInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitNumFloat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitNumLong(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    public void visitObjblock(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t2, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    public void visitOptionalDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?.", null, null);
    }

    public void visitPackageDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "package ", null, null);
    }

    public void visitParameterDef(GroovySourceAST t2, int visit) {
    }

    public void visitParameters(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 49) {
            this.printUpdatingTabLevel(t2, visit, null, ",", " ");
        } else {
            this.printUpdatingTabLevel(t2, visit, "(", ", ", ") ");
        }
    }

    public void visitPlus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " + ", null, null);
    }

    public void visitPlusAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " += ", null, null);
    }

    public void visitPostDec(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, null, "--");
    }

    public void visitPostInc(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, null, "++");
    }

    public void visitQuestion(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?", ":", null);
    }

    public void visitRangeExclusive(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "..<", null, null);
    }

    public void visitRangeInclusive(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "..", null, null);
    }

    public void visitRegexFind(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " =~ ", null, null);
    }

    public void visitRegexMatch(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ==~ ", null, null);
    }

    public void visitSelectSlot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "@", null, null);
    }

    public void visitSl(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " << ", null, null);
    }

    public void visitSlAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <<= ", null, null);
    }

    public void visitSlist(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t2, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    public void visitSpreadArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*", null, null);
    }

    public void visitSpreadDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*.", null, null);
    }

    public void visitSpreadMapArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*:", null, null);
    }

    public void visitSr(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >> ", null, null);
    }

    public void visitSrAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>= ", null, null);
    }

    public void visitStar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*", null, null);
    }

    public void visitStarAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " *= ", null, null);
    }

    public void visitStarStar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "**", null, null);
    }

    public void visitStarStarAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " **= ", null, null);
    }

    public void visitStaticInit(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "static ", null, null);
    }

    public void visitStaticImport(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "import static ", null, null);
    }

    public void visitStrictfp(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "strictfp ", null, null);
    }

    public void visitStringConstructor(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.stringConstructorCounter = 0;
            this.print(t2, visit, "\"");
        }
        if (visit == 3) {
            if (this.stringConstructorCounter % 2 == 0) {
                this.print(t2, visit, "$");
            }
            ++this.stringConstructorCounter;
        }
        if (visit == 4) {
            this.print(t2, visit, "\"");
        }
    }

    public void visitStringLiteral(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            String theString = this.escape(t2.getText());
            if (this.getParentNode().getType() != 53 && this.getParentNode().getType() != 47) {
                theString = "\"" + theString + "\"";
            }
            this.print(t2, visit, theString);
        }
    }

    private String escape(String literal) {
        literal = literal.replaceAll("\n", "\\\\<<REMOVE>>n");
        literal = literal.replaceAll("<<REMOVE>>", "");
        return literal;
    }

    public void visitSuperCtorCall(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "super(", " ", ")");
    }

    public void visitType(GroovySourceAST t2, int visit) {
        GroovySourceAST parent = this.getParentNode();
        GroovySourceAST modifiers = parent.childOfType(5);
        if (modifiers == null || modifiers.getNumberOfChildren() == 0) {
            if (visit == 1 && t2.getNumberOfChildren() == 0 && parent.getType() != 20) {
                this.print(t2, visit, "def");
            }
            if (visit == 4 && (parent.getType() == 9 || parent.getType() == 8 || parent.getType() == 67 || parent.getType() == 20 && t2.getNumberOfChildren() != 0)) {
                this.print(t2, visit, " ");
            }
        } else if (visit == 4 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " ");
        }
    }

    public void visitTypeArgument(GroovySourceAST t2, int visit) {
    }

    public void visitTypeArguments(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "<", ", ", ">");
    }

    public void visitTypecast(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", null, ")");
    }

    public void visitTypeLowerBounds(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " super ", " & ", null);
    }

    public void visitTypeParameter(GroovySourceAST t2, int visit) {
    }

    public void visitTypeParameters(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "<", ", ", ">");
    }

    public void visitTypeUpperBounds(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " extends ", " & ", null);
    }

    public void visitUnaryMinus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "-", null, null);
    }

    public void visitUnaryPlus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "+", null, null);
    }

    public void visitVariableDef(GroovySourceAST t2, int visit) {
    }

    public void visitVariableParameterDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, "... ", null);
    }

    public void visitWildcardType(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?", null, null);
    }

    public void visitDefault(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "<" + this.tokenNames[t2.getType()] + ">");
        } else {
            this.print(t2, visit, "</" + this.tokenNames[t2.getType()] + ">");
        }
    }

    protected void printUpdatingTabLevel(GroovySourceAST t2, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t2, visit, opening);
            ++this.tabLevel;
        }
        if (visit == 3 && subsequent != null) {
            this.print(t2, visit, subsequent);
        }
        if (visit == 4 && closing != null) {
            --this.tabLevel;
            this.print(t2, visit, closing);
        }
    }

    protected void print(GroovySourceAST t2, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t2, visit, opening);
        }
        if (visit == 3 && subsequent != null) {
            this.print(t2, visit, subsequent);
        }
        if (visit == 4 && closing != null) {
            this.print(t2, visit, closing);
        }
    }

    protected void print(GroovySourceAST t2, int visit, String value) {
        if (visit == 1) {
            this.printNewlineAndIndent(t2, visit);
        }
        if (visit == 4) {
            this.printNewlineAndIndent(t2, visit);
        }
        this.out.print(value);
    }

    protected void printNewlineAndIndent(GroovySourceAST t2, int visit) {
        int currentLine = t2.getLine();
        if (this.lastLinePrinted == 0) {
            this.lastLinePrinted = currentLine;
        }
        if (this.lastLinePrinted != currentLine) {
            if (this.newLines && (visit != 1 || t2.getType() != 7)) {
                int i2;
                for (i2 = this.lastLinePrinted; i2 < currentLine; ++i2) {
                    this.out.println();
                }
                if (this.lastLinePrinted > currentLine) {
                    this.out.println();
                    this.lastLinePrinted = currentLine;
                }
                if (visit == 1 || visit == 4 && this.lastLinePrinted > currentLine) {
                    for (i2 = 0; i2 < this.tabLevel; ++i2) {
                        this.out.print("    ");
                    }
                }
            }
            this.lastLinePrinted = Math.max(currentLine, this.lastLinePrinted);
        }
    }

    public void push(GroovySourceAST t2) {
        this.stack.push(t2);
    }

    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return (GroovySourceAST)this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        Object currentNode = this.stack.pop();
        Object parentNode = this.stack.peek();
        this.stack.push(currentNode);
        return (GroovySourceAST)parentNode;
    }
}

