/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Set<String> IGNORED_PACKAGES;
    private static final Method MAGIC_METHOD;

    public static boolean isCallingClassReflectionAvailable() {
        return MAGIC_METHOD != null;
    }

    public static Class getCallingClass() {
        return ReflectionUtils.getCallingClass(1);
    }

    public static Class getCallingClass(int matchLevel) {
        return ReflectionUtils.getCallingClass(matchLevel, Collections.EMPTY_SET);
    }

    public static Class getCallingClass(int matchLevel, Collection<String> extraIgnoredPackages) {
        if (MAGIC_METHOD == null) {
            return null;
        }
        int depth = 0;
        try {
            Class sc;
            Class c2;
            do {
                sc = (c2 = (Class)MAGIC_METHOD.invoke(null, depth++)) != null ? c2.getSuperclass() : null;
            } while (ReflectionUtils.classShouldBeIgnored(c2, extraIgnoredPackages) || ReflectionUtils.superClassShouldBeIgnored(sc) || c2 != null && matchLevel-- > 0);
            return c2;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    private static boolean superClassShouldBeIgnored(Class sc) {
        return sc != null && sc.getPackage() != null && "org.codehaus.groovy.runtime.callsite".equals(sc.getPackage().getName());
    }

    private static boolean classShouldBeIgnored(Class c2, Collection<String> extraIgnoredPackages) {
        return c2 != null && (c2.isSynthetic() || c2.getPackage() != null && (IGNORED_PACKAGES.contains(c2.getPackage().getName()) || extraIgnoredPackages.contains(c2.getPackage().getName())));
    }

    static {
        Method meth;
        IGNORED_PACKAGES = new HashSet<String>();
        IGNORED_PACKAGES.add("groovy.lang");
        IGNORED_PACKAGES.add("org.codehaus.groovy.reflection");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime.callsite");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime.metaclass");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime");
        IGNORED_PACKAGES.add("sun.reflect");
        IGNORED_PACKAGES.add("java.lang.invoke");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v7");
        try {
            Class<?> srr = Class.forName("sun.reflect.Reflection");
            meth = srr.getMethod("getCallerClass", Integer.TYPE);
        }
        catch (Throwable t2) {
            meth = null;
        }
        MAGIC_METHOD = meth;
    }
}

