/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class StackTraceUtils {
    public static final String STACK_LOG_NAME = "StackTrace";
    private static final Logger STACK_LOG;
    private static final String[] GROOVY_PACKAGES;
    private static List<Closure> tests;

    public static void addClassTest(Closure test) {
        tests.add(test);
    }

    public static Throwable sanitize(Throwable t2) {
        if (!Boolean.getBoolean("groovy.full.stacktrace")) {
            StackTraceElement[] trace = t2.getStackTrace();
            ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
            for (StackTraceElement stackTraceElement : trace) {
                if (!StackTraceUtils.isApplicationClass(stackTraceElement.getClassName())) continue;
                newTrace.add(stackTraceElement);
            }
            STACK_LOG.log(Level.WARNING, "Sanitizing stacktrace:", t2);
            StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
            newTrace.toArray(clean);
            t2.setStackTrace(clean);
        }
        return t2;
    }

    public static void printSanitizedStackTrace(Throwable t2, PrintWriter p2) {
        StackTraceElement[] trace;
        t2 = StackTraceUtils.sanitize(t2);
        for (StackTraceElement stackTraceElement : trace = t2.getStackTrace()) {
            p2.println("at " + stackTraceElement.getClassName() + "(" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }

    public static void printSanitizedStackTrace(Throwable t2) {
        StackTraceUtils.printSanitizedStackTrace(t2, new PrintWriter(System.err));
    }

    public static boolean isApplicationClass(String className) {
        for (Closure test : tests) {
            Object result = test.call((Object)className);
            if (result == null) continue;
            return DefaultTypeTransformation.castToBoolean(result);
        }
        for (String groovyPackage : GROOVY_PACKAGES) {
            if (!className.startsWith(groovyPackage)) continue;
            return false;
        }
        return true;
    }

    public static Throwable extractRootCause(Throwable t2) {
        Throwable result = t2;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static Throwable sanitizeRootCause(Throwable t2) {
        return StackTraceUtils.sanitize(StackTraceUtils.extractRootCause(t2));
    }

    public static Throwable deepSanitize(Throwable t2) {
        Throwable current = t2;
        while (current.getCause() != null) {
            current = StackTraceUtils.sanitize(current.getCause());
        }
        return StackTraceUtils.sanitize(t2);
    }

    static {
        block1: {
            Enumeration<String> existingLogs = LogManager.getLogManager().getLoggerNames();
            while (existingLogs.hasMoreElements()) {
                if (!STACK_LOG_NAME.equals(existingLogs.nextElement())) continue;
                STACK_LOG = Logger.getLogger(STACK_LOG_NAME);
                break block1;
            }
            STACK_LOG = Logger.getLogger(STACK_LOG_NAME);
            STACK_LOG.setUseParentHandlers(false);
        }
        GROOVY_PACKAGES = System.getProperty("groovy.sanitized.stacktraces", "groovy.,org.codehaus.groovy.,java.,javax.,sun.,gjdk.groovy.,").split("(\\s|,)+");
        tests = new ArrayList<Closure>();
    }
}

