/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.MetaMethod;
import java.util.NoSuchElementException;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.GeneratedMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.MixinInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.util.FastArray;
import org.codehaus.groovy.util.SingleKeyHashMap;

public class MetaMethodIndex {
    public SingleKeyHashMap methodHeaders = new SingleKeyHashMap();
    protected Entry[] table;
    protected static final int DEFAULT_CAPACITY = 32;
    protected static final int MINIMUM_CAPACITY = 4;
    protected static final int MAXIMUM_CAPACITY = 0x10000000;
    protected int size;
    protected transient int threshold;

    public MetaMethodIndex(CachedClass theCachedClass) {
        this.init(32);
        CachedClass last = null;
        if (!theCachedClass.isInterface()) {
            for (CachedClass c2 = theCachedClass; c2 != null; c2 = c2.getCachedSuperClass()) {
                SingleKeyHashMap.Entry e2 = this.methodHeaders.getOrPut(c2.getTheClass());
                e2.value = new Header(c2.getTheClass(), last == null ? null : last.getTheClass());
                last = c2;
            }
        } else {
            SingleKeyHashMap.Entry e3 = this.methodHeaders.getOrPut(Object.class);
            e3.value = new Header(Object.class, theCachedClass.getTheClass());
        }
    }

    public static int hash(int h2) {
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2] = null;
        }
        this.size = 0;
    }

    public void init(int initCapacity) {
        this.threshold = initCapacity * 6 / 8;
        this.table = new Entry[initCapacity];
    }

    public void resize(int newLength) {
        Entry[] oldTable = this.table;
        int oldLength = this.table.length;
        Entry[] newTable = new Entry[newLength];
        for (int j2 = 0; j2 < oldLength; ++j2) {
            Entry e2 = oldTable[j2];
            while (e2 != null) {
                Entry next = e2.nextHashEntry;
                int index = e2.hash & newLength - 1;
                e2.nextHashEntry = newTable[index];
                newTable[index] = e2;
                e2 = next;
            }
        }
        this.table = newTable;
        this.threshold = 6 * newLength / 8;
    }

    public Entry[] getTable() {
        return this.table;
    }

    public EntryIterator getEntrySetIterator() {
        return new EntryIterator(){
            Entry next;
            int index;
            Entry current;
            {
                Entry[] t2 = MetaMethodIndex.this.table;
                int i2 = t2.length;
                Entry n2 = null;
                if (MetaMethodIndex.this.size != 0) {
                    while (i2 > 0 && (n2 = t2[--i2]) == null) {
                    }
                }
                this.next = n2;
                this.index = i2;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Entry next() {
                return this.nextEntry();
            }

            Entry nextEntry() {
                Entry e2 = this.next;
                if (e2 == null) {
                    throw new NoSuchElementException();
                }
                Entry n2 = e2.nextHashEntry;
                Entry[] t2 = MetaMethodIndex.this.table;
                int i2 = this.index;
                while (n2 == null && i2 > 0) {
                    n2 = t2[--i2];
                }
                this.index = i2;
                this.next = n2;
                this.current = e2;
                return this.current;
            }
        };
    }

    public final Entry getMethods(Class cls, String name) {
        int h2 = MetaMethodIndex.hash(31 * cls.hashCode() + name.hashCode());
        Entry e2 = this.table[h2 & this.table.length - 1];
        while (e2 != null) {
            if (e2.hash == h2 && cls == e2.cls && (e2.name == name || e2.name.equals(name))) {
                return e2;
            }
            e2 = e2.nextHashEntry;
        }
        return null;
    }

    public Entry getOrPutMethods(String name, Header header) {
        Class cls = header.cls;
        int h2 = MetaMethodIndex.hash(header.clsHashCode31 + name.hashCode());
        Entry[] t2 = this.table;
        int index = h2 & t2.length - 1;
        Entry e2 = t2[index];
        while (e2 != null) {
            if (e2.hash == h2 && cls == e2.cls && (e2.name == name || e2.name.equals(name))) {
                return e2;
            }
            e2 = e2.nextHashEntry;
        }
        Entry entry = new Entry();
        entry.nextHashEntry = t2[index];
        entry.hash = h2;
        entry.name = name.intern();
        entry.cls = cls;
        t2[index] = entry;
        entry.nextClassEntry = header.head;
        header.head = entry;
        if (++this.size == this.threshold) {
            this.resize(2 * t2.length);
        }
        return entry;
    }

    public Header getHeader(Class cls) {
        SingleKeyHashMap.Entry head = this.methodHeaders.getOrPut(cls);
        if (head.value == null) {
            head.value = new Header(cls);
        }
        Header header = (Header)head.value;
        return header;
    }

    public void copyNonPrivateMethods(Class from, Class to) {
        this.copyNonPrivateMethods(this.getHeader(from), this.getHeader(to));
    }

    public void copyNonPrivateMethods(Header from, Header to) {
        Entry e2 = from.head;
        while (e2 != null) {
            this.copyNonPrivateMethods(e2, to);
            e2 = e2.nextClassEntry;
        }
    }

    public void copyAllMethodsToSuper(Header from, Header to) {
        Entry e2 = from.head;
        while (e2 != null) {
            this.copyAllMethodsToSuper(e2, to);
            e2 = e2.nextClassEntry;
        }
    }

    public void copyNonPrivateMethodsFromSuper(Header from) {
        Entry e2 = from.head;
        while (e2 != null) {
            this.copyNonPrivateMethodsFromSuper(e2);
            e2 = e2.nextClassEntry;
        }
    }

    private void copyNonPrivateMethods(Entry from, Header to) {
        Object oldListOrMethod = from.methods;
        if (oldListOrMethod instanceof FastArray) {
            FastArray oldList = (FastArray)oldListOrMethod;
            Entry e2 = null;
            int len1 = oldList.size();
            Object[] list = oldList.getArray();
            for (int j2 = 0; j2 != len1; ++j2) {
                MetaMethod method = (MetaMethod)list[j2];
                if (method.isPrivate()) continue;
                if (e2 == null) {
                    e2 = this.getOrPutMethods(from.name, to);
                }
                e2.methods = this.addMethodToList(e2.methods, method);
            }
        } else {
            MetaMethod method = (MetaMethod)oldListOrMethod;
            if (!method.isPrivate()) {
                Entry e3 = this.getOrPutMethods(from.name, to);
                e3.methods = this.addMethodToList(e3.methods, method);
            }
        }
    }

    private void copyAllMethodsToSuper(Entry from, Header to) {
        Object oldListOrMethod = from.methods;
        if (oldListOrMethod instanceof FastArray) {
            FastArray oldList = (FastArray)oldListOrMethod;
            Entry e2 = null;
            int len1 = oldList.size();
            Object[] list = oldList.getArray();
            for (int j2 = 0; j2 != len1; ++j2) {
                MetaMethod method = (MetaMethod)list[j2];
                if (e2 == null) {
                    e2 = this.getOrPutMethods(from.name, to);
                }
                e2.methodsForSuper = this.addMethodToList(e2.methodsForSuper, method);
            }
        } else {
            MetaMethod method = (MetaMethod)oldListOrMethod;
            Entry e3 = this.getOrPutMethods(from.name, to);
            e3.methodsForSuper = this.addMethodToList(e3.methodsForSuper, method);
        }
    }

    private void copyNonPrivateMethodsFromSuper(Entry e2) {
        Object oldListOrMethod = e2.methodsForSuper;
        if (oldListOrMethod == null) {
            return;
        }
        if (oldListOrMethod instanceof FastArray) {
            FastArray oldList = (FastArray)oldListOrMethod;
            int len1 = oldList.size();
            Object[] list = oldList.getArray();
            for (int j2 = 0; j2 != len1; ++j2) {
                MetaMethod method = (MetaMethod)list[j2];
                if (method.isPrivate()) continue;
                e2.methods = this.addMethodToList(e2.methods, method);
            }
        } else {
            MetaMethod method = (MetaMethod)oldListOrMethod;
            if (!method.isPrivate()) {
                e2.methods = this.addMethodToList(e2.methods, method);
            }
        }
    }

    public void copyNonPrivateMethodsDown(Class from, Class to) {
        this.copyNonPrivateNonNewMetaMethods(this.getHeader(from), this.getHeader(to));
    }

    public void copyNonPrivateNonNewMetaMethods(Header from, Header to) {
        Entry e2 = from.head;
        while (e2 != null) {
            this.copyNonPrivateNonNewMetaMethods(e2, to);
            e2 = e2.nextClassEntry;
        }
    }

    private void copyNonPrivateNonNewMetaMethods(Entry from, Header to) {
        Object oldListOrMethod = from.methods;
        if (oldListOrMethod == null) {
            return;
        }
        if (oldListOrMethod instanceof FastArray) {
            FastArray oldList = (FastArray)oldListOrMethod;
            Entry e2 = null;
            int len1 = oldList.size();
            Object[] list = oldList.getArray();
            for (int j2 = 0; j2 != len1; ++j2) {
                MetaMethod method = (MetaMethod)list[j2];
                if (method instanceof NewMetaMethod || method.isPrivate()) continue;
                if (e2 == null) {
                    e2 = this.getOrPutMethods(from.name, to);
                }
                e2.methods = this.addMethodToList(e2.methods, method);
            }
        } else {
            MetaMethod method = (MetaMethod)oldListOrMethod;
            if (method instanceof NewMetaMethod || method.isPrivate()) {
                return;
            }
            Entry e3 = this.getOrPutMethods(from.name, to);
            e3.methods = this.addMethodToList(e3.methods, method);
        }
    }

    public Object addMethodToList(Object o2, MetaMethod method) {
        if (o2 == null) {
            return method;
        }
        if (o2 instanceof MetaMethod) {
            CachedClass matchC;
            CachedClass methodC;
            MetaMethod match = (MetaMethod)o2;
            if (!this.isMatchingMethod(match, method)) {
                FastArray list = new FastArray(2);
                list.add(match);
                list.add(method);
                return list;
            }
            if (!match.isPrivate() && (this.isNonRealMethod(match) || !match.getDeclaringClass().isInterface() || method.getDeclaringClass().isInterface()) && ((methodC = method.getDeclaringClass()) == (matchC = match.getDeclaringClass()) ? this.isNonRealMethod(method) : !methodC.isAssignableFrom(matchC.getTheClass()))) {
                return method;
            }
            return o2;
        }
        if (o2 instanceof FastArray) {
            FastArray list = (FastArray)o2;
            int found = this.findMatchingMethod(list, method);
            if (found == -1) {
                list.add(method);
            } else {
                MetaMethod match = (MetaMethod)list.get(found);
                if (match == method) {
                    return o2;
                }
                if (!match.isPrivate() && (this.isNonRealMethod(match) || !match.getDeclaringClass().isInterface() || method.getDeclaringClass().isInterface())) {
                    CachedClass matchC;
                    CachedClass methodC = method.getDeclaringClass();
                    if (methodC == (matchC = match.getDeclaringClass())) {
                        if (this.isNonRealMethod(method)) {
                            list.set(found, method);
                        }
                    } else if (!methodC.isAssignableFrom(matchC.getTheClass())) {
                        list.set(found, method);
                    }
                }
            }
        }
        return o2;
    }

    private boolean isNonRealMethod(MetaMethod method) {
        return method instanceof NewInstanceMetaMethod || method instanceof NewStaticMetaMethod || method instanceof ClosureMetaMethod || method instanceof GeneratedMetaMethod || method instanceof ClosureStaticMetaMethod || method instanceof MixinInstanceMetaMethod || method instanceof ClosureMetaMethod.AnonymousMetaMethod;
    }

    private boolean isMatchingMethod(MetaMethod aMethod, MetaMethod method) {
        CachedClass[] params2;
        if (aMethod == method) {
            return true;
        }
        CachedClass[] params1 = aMethod.getParameterTypes();
        if (params1.length != (params2 = method.getParameterTypes()).length) {
            return false;
        }
        boolean matches = true;
        for (int i2 = 0; i2 < params1.length; ++i2) {
            if (params1[i2] == params2[i2]) continue;
            matches = false;
            break;
        }
        return matches;
    }

    private int findMatchingMethod(FastArray list, MetaMethod method) {
        int len = list.size();
        Object[] data = list.getArray();
        for (int j2 = 0; j2 != len; ++j2) {
            MetaMethod aMethod = (MetaMethod)data[j2];
            if (!this.isMatchingMethod(aMethod, method)) continue;
            return j2;
        }
        return -1;
    }

    public void copyMethodsToSuper() {
        for (Entry e2 : this.table) {
            while (e2 != null) {
                e2.methodsForSuper = e2.methods instanceof FastArray ? ((FastArray)e2.methods).copy() : e2.methods;
                e2 = e2.nextHashEntry;
            }
        }
    }

    public void copy(Class c2, Header index) {
        this.copy(this.getHeader(c2), index);
    }

    public void copy(Header from, Header to) {
        Entry e2 = from.head;
        while (e2 != null) {
            this.copyAllMethods(e2, to);
            e2 = e2.nextClassEntry;
        }
    }

    private void copyAllMethods(Entry from, Header to) {
        Object oldListOrMethod = from.methods;
        if (oldListOrMethod instanceof FastArray) {
            FastArray oldList = (FastArray)oldListOrMethod;
            Entry e2 = null;
            int len1 = oldList.size();
            Object[] list = oldList.getArray();
            for (int j2 = 0; j2 != len1; ++j2) {
                MetaMethod method = (MetaMethod)list[j2];
                if (e2 == null) {
                    e2 = this.getOrPutMethods(from.name, to);
                }
                e2.methods = this.addMethodToList(e2.methods, method);
            }
        } else {
            MetaMethod method = (MetaMethod)oldListOrMethod;
            if (!method.isPrivate()) {
                Entry e3 = this.getOrPutMethods(from.name, to);
                e3.methods = this.addMethodToList(e3.methods, method);
            }
        }
    }

    public void clearCaches() {
        for (int i2 = 0; i2 != this.table.length; ++i2) {
            Entry e2 = this.table[i2];
            while (e2 != null) {
                e2.cachedStaticMethod = null;
                e2.cachedMethodForSuper = null;
                e2.cachedMethod = null;
                e2 = e2.nextHashEntry;
            }
        }
    }

    public void clearCaches(String name) {
        for (int i2 = 0; i2 != this.table.length; ++i2) {
            Entry e2 = this.table[i2];
            while (e2 != null) {
                if (e2.name.equals(name)) {
                    e2.cachedStaticMethod = null;
                    e2.cachedMethodForSuper = null;
                    e2.cachedMethod = null;
                }
                e2 = e2.nextHashEntry;
            }
        }
    }

    public static interface EntryIterator {
        public boolean hasNext();

        public Entry next();
    }

    public static class Entry {
        public int hash;
        public Entry nextHashEntry;
        public Entry nextClassEntry;
        public String name;
        public Class cls;
        public Object methods;
        public Object methodsForSuper;
        public Object staticMethods;
        public CacheEntry cachedMethod;
        public CacheEntry cachedMethodForSuper;
        public CacheEntry cachedStaticMethod;

        public String toString() {
            return "[" + this.name + ", " + this.cls.getName() + "]";
        }
    }

    public static class CacheEntry {
        public final Class[] params;
        public final MetaMethod method;

        public CacheEntry(Class[] params, MetaMethod method) {
            this.params = params;
            this.method = method;
        }
    }

    public static class Header {
        public Entry head;
        Class cls;
        public int clsHashCode31;
        public Class subclass;

        public Header(Class cls) {
            this(cls, null);
        }

        public Header(Class cls, Class subclass) {
            this.cls = cls;
            this.subclass = subclass;
            this.clsHashCode31 = 31 * cls.hashCode();
        }
    }
}

