/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Locale;
import org.jsoup.helper.Validate;

class CharacterReader {
    static final char EOF = '\uffff';
    private final char[] input;
    private final int length;
    private int pos = 0;
    private int mark = 0;

    CharacterReader(String input) {
        Validate.notNull(input);
        this.input = input.toCharArray();
        this.length = this.input.length;
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
    }

    char consume() {
        char val = this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
        ++this.pos;
        return val;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return new String(this.input, this.pos++, 1);
    }

    int nextIndexOf(char c2) {
        for (int i2 = this.pos; i2 < this.length; ++i2) {
            if (c2 != this.input[i2]) continue;
            return i2 - this.pos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        char startChar = seq.charAt(0);
        for (int offset = this.pos; offset < this.length; ++offset) {
            if (startChar != this.input[offset]) {
                while (++offset < this.length && startChar != this.input[offset]) {
                }
            }
            int i2 = offset + 1;
            int last = i2 + seq.length() - 1;
            if (offset >= this.length || last > this.length) continue;
            int j2 = 1;
            while (i2 < last && seq.charAt(j2) == this.input[i2]) {
                ++i2;
                ++j2;
            }
            if (i2 != last) continue;
            return offset - this.pos;
        }
        return -1;
    }

    String consumeTo(char c2) {
        int offset = this.nextIndexOf(c2);
        if (offset != -1) {
            String consumed = new String(this.input, this.pos, offset);
            this.pos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset = this.nextIndexOf(seq);
        if (offset != -1) {
            String consumed = new String(this.input, this.pos, offset);
            this.pos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... chars) {
        int start = this.pos;
        block0: while (this.pos < this.length) {
            for (int i2 = 0; i2 < chars.length; ++i2) {
                if (this.input[this.pos] == chars[i2]) break block0;
            }
            ++this.pos;
        }
        return this.pos > start ? new String(this.input, start, this.pos - start) : "";
    }

    String consumeToEnd() {
        String data = new String(this.input, this.pos, this.length - this.pos);
        this.pos = this.length;
        return data;
    }

    String consumeLetterSequence() {
        char c2;
        int start = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeLetterThenDigitSequence() {
        char c2;
        int start = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            ++this.pos;
        }
        while (!this.isEmpty() && (c2 = this.input[this.pos]) >= '0' && c2 <= '9') {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeHexSequence() {
        char c2;
        int start = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeDigitSequence() {
        char c2;
        int start = this.pos;
        while (this.pos < this.length && (c2 = this.input[this.pos]) >= '0' && c2 <= '9') {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    boolean matches(char c2) {
        return !this.isEmpty() && this.input[this.pos] == c2;
    }

    boolean matches(String seq) {
        int scanLength = seq.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            if (seq.charAt(offset) == this.input[this.pos + offset]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        int scanLength = seq.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset));
            if (upScan == (upTarget = Character.toUpperCase(this.input[this.pos + offset]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        for (char seek : seq) {
            if (seek != c2) continue;
            return true;
        }
        return false;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        return c2 >= '0' && c2 <= '9';
    }

    boolean matchConsume(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    public String toString() {
        return new String(this.input, this.pos, this.length - this.pos);
    }
}

