/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.codabar;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class CodabarLogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'n', 't', '-', '$', ':', '/', '.', '+', '*'};
    static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;

    public CodabarLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public CodabarLogicImpl(ChecksumMode mode, boolean displayStartStop) {
        this.checksumMode = mode;
        this.displayStartStop = displayStartStop;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    protected static int getCharIndex(char ch) {
        for (int i2 = 0; i2 < CHARACTERS.length; ++i2) {
            if (ch != CHARACTERS[i2]) continue;
            return i2;
        }
        return -1;
    }

    protected static boolean isValidChar(char ch) {
        return CodabarLogicImpl.getCharIndex(Character.toLowerCase(ch)) >= 0;
    }

    protected static boolean isStartStopChar(char ch) {
        return (ch = Character.toLowerCase(ch)) == 'a' || ch == 'b' || ch == 'c' || ch == 'd' || ch == 'e' || ch == '*' || ch == 'n' || ch == 't';
    }

    private int widthAt(char ch, int index) throws IllegalArgumentException {
        int chidx = CodabarLogicImpl.getCharIndex(ch = Character.toLowerCase(ch));
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char ch) {
        ch = Character.toLowerCase(ch);
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(ch).toString());
        for (int i2 = 0; i2 < 7; i2 = (int)((byte)(i2 + 1))) {
            int width = this.widthAt(ch, i2);
            boolean black = i2 % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    private void handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            throw new UnsupportedOperationException("No checksums are currently supported for Codabar symbols");
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return;
        }
    }

    private StringBuffer prepareMessage(String msg) {
        if (CodabarLogicImpl.isStartStopChar(msg.charAt(0)) && CodabarLogicImpl.isStartStopChar(msg.charAt(msg.length() - 1))) {
            return new StringBuffer(msg.substring(1, msg.length() - 1));
        }
        return new StringBuffer(msg);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        this.handleChecksum(sb);
        String effMsg = sb.toString();
        String displayMsg = this.displayStartStop ? sb.toString() : this.prepareMessage(msg).toString();
        logic.startBarcode(effMsg, displayMsg);
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            char ch;
            if (i2 > 0) {
                logic.addBar(false, 1);
            }
            if (!CodabarLogicImpl.isValidChar(ch = sb.charAt(i2))) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
        }
        logic.endBarcode();
    }
}

