/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import org.krysalis.barcode4j.impl.pdf417.PDF417Constants;

public class PDF417ErrorCorrection
implements PDF417Constants {
    public static int getErrorCorrectionCodewordCount(int errorCorrectionLevel) {
        if (errorCorrectionLevel < 0 || errorCorrectionLevel > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        return 1 << errorCorrectionLevel + 1;
    }

    public static int getRecommendedMinimumErrorCorrectionLevel(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (n2 >= 1 && n2 <= 40) {
            return 2;
        }
        if (n2 >= 41 && n2 <= 160) {
            return 3;
        }
        if (n2 >= 161 && n2 <= 320) {
            return 4;
        }
        if (n2 >= 321 && n2 <= 863) {
            return 5;
        }
        throw new IllegalArgumentException("No recommendation possible");
    }

    public static String generateErrorCorrection(String dataCodewords, int errorCorrectionLevel) {
        int j2;
        int k2 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        char[] e2 = new char[k2];
        int sld = dataCodewords.length();
        for (int i2 = 0; i2 < sld; ++i2) {
            int t3;
            int t2;
            int t1 = (dataCodewords.charAt(i2) + e2[e2.length - 1]) % 929;
            for (j2 = k2 - 1; j2 >= 1; --j2) {
                t2 = t1 * EC_COEFFICIENTS[errorCorrectionLevel][j2] % 929;
                t3 = 929 - t2;
                e2[j2] = (char)((e2[j2 - 1] + t3) % 929);
            }
            t2 = t1 * EC_COEFFICIENTS[errorCorrectionLevel][0] % 929;
            t3 = 929 - t2;
            e2[0] = (char)(t3 % 929);
        }
        StringBuffer sb = new StringBuffer(k2);
        for (j2 = k2 - 1; j2 >= 0; --j2) {
            if (e2[j2] != '\u0000') {
                e2[j2] = (char)(929 - e2[j2]);
            }
            sb.append(e2[j2]);
        }
        return sb.toString();
    }
}

