/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

public class MessagePatternUtil {
    public static String applyCustomMessagePattern(String msg, String pattern) {
        StringBuffer result = new StringBuffer();
        if (pattern == null || "".equals(pattern) || msg == null || "".equals(msg)) {
            return msg;
        }
        byte[] msgBytes = msg.getBytes();
        byte[] patternBytes = pattern.getBytes();
        int msgIndex = 0;
        boolean escapeCharEncountered = false;
        boolean msgFinished = false;
        for (int patternIndex = 0; patternIndex < patternBytes.length; ++patternIndex) {
            char currentPatternChar = (char)patternBytes[patternIndex];
            if (!escapeCharEncountered && MessagePatternUtil.isEscapeChar(currentPatternChar)) {
                escapeCharEncountered = true;
                continue;
            }
            if (!msgFinished && !escapeCharEncountered && (MessagePatternUtil.isPlaceholder(currentPatternChar) || MessagePatternUtil.isDeleteholder(currentPatternChar))) {
                if (!MessagePatternUtil.isDeleteholder(currentPatternChar)) {
                    result.append((char)msgBytes[msgIndex]);
                }
                if (++msgIndex != msgBytes.length) continue;
                msgFinished = true;
                continue;
            }
            if (escapeCharEncountered || !MessagePatternUtil.isPlaceholder(currentPatternChar)) {
                result.append(currentPatternChar);
            }
            escapeCharEncountered = false;
        }
        while (msgIndex < msgBytes.length) {
            result.append((char)msgBytes[msgIndex]);
            ++msgIndex;
        }
        return result.toString();
    }

    private static boolean isPlaceholder(char c2) {
        boolean result = false;
        char placeholderChar = '_';
        result = placeholderChar == c2;
        return result;
    }

    private static boolean isEscapeChar(char c2) {
        boolean result = false;
        char escapeChar = '\\';
        result = c2 == escapeChar;
        return result;
    }

    private static boolean isDeleteholder(char c2) {
        boolean result = false;
        char placeholderChar = '#';
        result = placeholderChar == c2;
        return result;
    }
}

