/*
 * Decompiled with CFR 0.152.
 */
package tangram.dbf;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import tangram.dbf.TngDbfBase;
import tangram.dbf.TngDbfField;
import tangram.dbf.TngDbfHeader;
import tangram.dbf.TngDbfUtils;
import tangram.exception.TngExceptionDbf;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngDbfWriter
extends TngDbfBase {
    private TngDbfHeader header;
    private Vector v_records = new Vector();
    private int recordCount = 0;
    private RandomAccessFile raf = null;

    public TngDbfWriter() {
        this.header = new TngDbfHeader();
    }

    public TngDbfHeader getHeader() {
        return this.header;
    }

    public int getRecordCount() {
        return this.header.getNumberOfRecords();
    }

    public TngDbfField getField(int index) {
        return this.header.getFields()[index];
    }

    public int getFieldCount() {
        if (this.header.getFields() != null) {
            return this.header.getFields().length;
        }
        return -1;
    }

    public TngDbfWriter(File dbfFile) throws TngExceptionDbf {
        try {
            this.raf = new RandomAccessFile(dbfFile, "rw");
            if (!dbfFile.exists() || dbfFile.length() == 0L) {
                this.header = new TngDbfHeader();
                return;
            }
            this.header = new TngDbfHeader();
            this.header.read(this.raf);
            this.raf.seek(this.raf.length() - 1L);
        }
        catch (FileNotFoundException e2) {
            throw new TngExceptionDbf(Nat.x("S\u00fabor nebol n\u00e1jden\u00fd:") + " " + e2.getMessage());
        }
        catch (IOException e3) {
            throw new TngExceptionDbf(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed hlavi\u010dky DBF s\u00faboru:") + " " + e3.getMessage());
        }
        this.recordCount = this.header.getNumberOfRecords();
    }

    public void setFields(TngDbfField[] fields) throws TngExceptionDbf {
        if (this.header.getFields() != null) {
            throw new TngExceptionDbf(Nat.x("Polo\u017eky hlavi\u010dky DBF s\u00faboru u\u017e boli nastaven\u00e9"));
        }
        if (fields == null || fields.length == 0) {
            throw new TngExceptionDbf(Nat.x("Hlavi\u010dka DBF s\u00faboru mus\u00ed obsahova\u0165 aspo\u0148 jednu polo\u017eku"));
        }
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (fields[i2] != null) continue;
            throw new TngExceptionDbf(Nat.x("Polo\u017eka hlavi\u010dky DBF s\u00faboru \u010d. %1 je pr\u00e1zdna", i2 + 1));
        }
        this.header.setFields(fields);
        try {
            if (this.raf != null && this.raf.length() == 0L) {
                this.header.write(this.raf);
            }
        }
        catch (IOException e2) {
            throw new TngExceptionDbf(Nat.x("Chyba pri z\u00e1pise do DBF s\u00faboru:") + " " + e2.getMessage());
        }
    }

    public void addRecord(Object[] values) throws TngExceptionDbf {
        if (this.header.getFields() == null) {
            throw new TngExceptionDbf(Nat.x("Hlavi\u010dka DBF s\u00faboru mus\u00ed by\u0165 nastaven\u00e1 pred pridan\u00edm z\u00e1znamu"));
        }
        if (values == null) {
            throw new TngExceptionDbf(Nat.x("Pr\u00e1zdna polo\u017eka nem\u00f4\u017ee by\u0165 pridan\u00e1 ako z\u00e1znam do DBF s\u00faboru"));
        }
        if (values.length != this.getFieldCount()) {
            throw new TngExceptionDbf(Nat.x("Po\u010det polo\u017eiek v z\u00e1zname sa nezhoduje s po\u010dtom polo\u017eiek hlavi\u010dky DBF s\u00faboru"));
        }
        block9: for (int i2 = 0; i2 < this.getFieldCount(); ++i2) {
            if (values[i2] == null) continue;
            switch (this.getField(i2).getDataType()) {
                case 67: {
                    if (values[i2] instanceof String) continue block9;
                    throw new TngExceptionDbf(Nat.x("Nespr\u00e1vna hodnota [%1] CHAR polo\u017eky %2", values[i2], this.getField(i2).getFieldName()));
                }
                case 76: {
                    if (values[i2] instanceof Boolean) continue block9;
                    throw new TngExceptionDbf(Nat.x("Nespr\u00e1vna hodnota [%1] BOOLEAN polo\u017eky %2", values[i2], this.getField(i2).getFieldName()));
                }
                case 78: {
                    if (values[i2] instanceof Double) continue block9;
                    throw new TngExceptionDbf(Nat.x("Nespr\u00e1vna hodnota [%1] DOUBLE polo\u017eky %2", values[i2], this.getField(i2).getFieldName()));
                }
                case 68: {
                    if (values[i2] instanceof Date) continue block9;
                    throw new TngExceptionDbf(Nat.x("Nespr\u00e1vna hodnota [%1] DATE polo\u017eky %2", values[i2], this.getField(i2).getFieldName()));
                }
                case 70: {
                    if (values[i2] instanceof Double) continue block9;
                    throw new TngExceptionDbf(Nat.x("Nespr\u00e1vna hodnota [%1] DOUBLE polo\u017eky %2", values[i2], this.getField(i2).getFieldName()));
                }
            }
        }
        if (this.raf == null) {
            this.v_records.addElement(values);
        } else {
            try {
                this.writeRecord(this.raf, values);
                ++this.recordCount;
            }
            catch (IOException e2) {
                throw new TngExceptionDbf(Nat.x("Chyba pri z\u00e1pise z\u00e1znamu do DBF s\u00faboru:") + " " + e2.getMessage());
            }
        }
    }

    public void write(OutputStream out) throws TngExceptionDbf {
        try {
            if (this.raf == null) {
                DataOutputStream outStream = new DataOutputStream(out);
                this.header.setNumberOfRecords(this.v_records.size());
                this.header.write(outStream);
                int t_recCount = this.v_records.size();
                for (int i2 = 0; i2 < t_recCount; ++i2) {
                    Object[] t_values = (Object[])this.v_records.elementAt(i2);
                    this.writeRecord(outStream, t_values);
                }
                outStream.write(26);
                outStream.flush();
            } else {
                this.header.setNumberOfRecords(this.recordCount);
                this.raf.seek(0L);
                this.header.write(this.raf);
                this.raf.seek(this.raf.length());
                this.raf.writeByte(26);
                this.raf.close();
            }
        }
        catch (IOException e2) {
            throw new TngExceptionDbf(e2.getMessage());
        }
        finally {
            TngUtilities.streamCloseSafe(out);
        }
    }

    public void write() throws TngExceptionDbf {
        this.write(null);
    }

    private void writeRecord(DataOutput dataOutput, Object[] objectArray) throws IOException {
        dataOutput.write(32);
        block8: for (int j2 = 0; j2 < this.getFieldCount(); ++j2) {
            TngDbfField f2 = this.getField(j2);
            switch (f2.getDataType()) {
                case 67: {
                    if (objectArray[j2] != null) {
                        String str_value = objectArray[j2].toString();
                        dataOutput.write(TngDbfUtils.textPadding(str_value, this.characterSetName, f2.getFieldLength()));
                        continue block8;
                    }
                    dataOutput.write(TngDbfUtils.textPadding("", this.characterSetName, f2.getFieldLength()));
                    continue block8;
                }
                case 68: {
                    if (objectArray[j2] != null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime((Date)objectArray[j2]);
                        dataOutput.write(TngDbfUtils.textPadding(String.valueOf(calendar.get(1)), this.characterSetName, 4, 12, (byte)48));
                        dataOutput.write(TngDbfUtils.textPadding(String.valueOf(calendar.get(2) + 1), this.characterSetName, 2, 12, (byte)48));
                        dataOutput.write(TngDbfUtils.textPadding(String.valueOf(calendar.get(5)), this.characterSetName, 2, 12, (byte)48));
                        continue block8;
                    }
                    dataOutput.write("        ".getBytes());
                    continue block8;
                }
                case 70: {
                    if (objectArray[j2] != null) {
                        dataOutput.write(TngDbfUtils.doubleFormating((Double)objectArray[j2], this.characterSetName, f2.getFieldLength(), f2.getDecimalCount()));
                        continue block8;
                    }
                    dataOutput.write(TngDbfUtils.textPadding("?", this.characterSetName, f2.getFieldLength(), 12));
                    continue block8;
                }
                case 78: {
                    if (objectArray[j2] != null) {
                        dataOutput.write(TngDbfUtils.doubleFormating((Double)objectArray[j2], this.characterSetName, f2.getFieldLength(), f2.getDecimalCount()));
                        continue block8;
                    }
                    dataOutput.write(TngDbfUtils.textPadding("?", this.characterSetName, f2.getFieldLength(), 12));
                    continue block8;
                }
                case 76: {
                    if (objectArray[j2] != null) {
                        if ((Boolean)objectArray[j2] == Boolean.TRUE) {
                            dataOutput.write(84);
                            continue block8;
                        }
                        dataOutput.write(70);
                        continue block8;
                    }
                    dataOutput.write(63);
                    continue block8;
                }
                case 77: {
                    continue block8;
                }
                default: {
                    throw new TngExceptionDbf(Nat.x("Nezn\u00e1my typ DBF polo\u017eky %1", f2.getDataType()));
                }
            }
        }
    }
}

