/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import tangram.dm.Schema;
import tangram.dm.Version;
import tangram.library.Nat;

public final class SchemaAccessorXml {
    public static final String CUSTOM = "custom";
    public static final String XML_EXT = ".xml";
    public static final String DM_EXT = ".dm";

    private SchemaAccessorXml() {
    }

    public static File findZipFile(String dir, String schemaName) {
        String fileName = schemaName + DM_EXT;
        File file = new File(dir, fileName);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static File findXmlFile(String dir, String schemaName, Version version) {
        String fileName = SchemaAccessorXml.getFileName(schemaName, version);
        File file = new File(dir, fileName);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static File[] getCustomXmlFiles(String dir) {
        File file = new File(dir, CUSTOM);
        if (!file.isDirectory()) {
            return new File[0];
        }
        return file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().endsWith(SchemaAccessorXml.XML_EXT);
            }
        });
    }

    public static Schema loadFromXmlFile(File file) throws Exception {
        return SchemaAccessorXml.loadFromXmlFile(file, null);
    }

    public static Schema loadFromXmlFile(File file, String schemaName) throws Exception {
        String source = Nat.x("S\u00fabor(%1)", file.getName());
        return SchemaAccessorXml.loadFromStream(new FileInputStream(file), source, schemaName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema loadFromZipZile(File file, String schemaName, Version version) throws Exception {
        Schema schema;
        ZipFile zipFile = null;
        try {
            Schema schema2;
            zipFile = new ZipFile(file);
            InputStream inputStream = SchemaAccessorXml.openZipInputStream(zipFile, schemaName, version);
            String source = "Zip(" + file.getName() + "):" + Nat.x("S\u00fabor(%1)", SchemaAccessorXml.getFileName(schemaName, version));
            schema = schema2 = SchemaAccessorXml.loadFromStream(inputStream, source, schemaName, version);
        }
        catch (Throwable throwable) {
            SchemaAccessorXml.closeSafeZipFile(zipFile);
            throw throwable;
        }
        SchemaAccessorXml.closeSafeZipFile(zipFile);
        return schema;
    }

    public static void extendByCustom(Schema schema, String dir) throws Exception {
        File[] customs = SchemaAccessorXml.getCustomXmlFiles(dir);
        for (int i2 = 0; i2 < customs.length; ++i2) {
            Schema s2 = SchemaAccessorXml.loadFromXmlFile(customs[i2], schema.name);
            schema.extend(s2);
        }
    }

    private static InputStream openZipInputStream(ZipFile zipFile, String schemaName, Version version) throws Exception {
        String fileName = SchemaAccessorXml.getFileName(schemaName, version);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(fileName)) continue;
            return zipFile.getInputStream(zipEntry);
        }
        throw new Exception(Nat.x("S\u00fabor \u0161trukt\u00fary %1 neobsahuje verziu %2", zipFile.getName(), version.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVersionInZipFile(File file, String schemaName, Version version) throws Exception {
        boolean bl;
        ZipFile zipFile;
        block4: {
            boolean bl2;
            zipFile = null;
            try {
                zipFile = new ZipFile(file);
                String fileName = SchemaAccessorXml.getFileName(schemaName, version);
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    if (!zipEntry.getName().equalsIgnoreCase(fileName)) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                SchemaAccessorXml.closeSafeZipFile(zipFile);
                throw throwable;
            }
            SchemaAccessorXml.closeSafeZipFile(zipFile);
            return bl2;
        }
        SchemaAccessorXml.closeSafeZipFile(zipFile);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Version> getVersionsFromZipFile(File file, String schemaName) throws Exception {
        ArrayList<Version> arrayList;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ArrayList<Version> versions = new ArrayList<Version>();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                Version version = SchemaAccessorXml.extractVersionFromFileName(schemaName, zipEntry.getName());
                if (version == null) continue;
                versions.add(version);
            }
            Collections.sort(versions);
            arrayList = versions;
        }
        catch (Throwable throwable) {
            SchemaAccessorXml.closeSafeZipFile(zipFile);
            throw throwable;
        }
        SchemaAccessorXml.closeSafeZipFile(zipFile);
        return arrayList;
    }

    public static ArrayList<Version> getVersionsFromZipFile(File file, String schemaName, Version versionFrom, Version versionTo) throws Exception {
        ArrayList<Version> versions = SchemaAccessorXml.getVersionsFromZipFile(file, schemaName);
        return SchemaAccessorXml.filterVersion(versions, versionFrom, versionTo);
    }

    public static ArrayList<Version> filterVersion(ArrayList<Version> versions, Version versionFrom, Version versionTo) {
        ArrayList<Version> filterred = new ArrayList<Version>(versions.size());
        for (int i2 = 0; i2 < versions.size(); ++i2) {
            Version v2 = versions.get(i2);
            if (versionFrom != null && versionFrom.compareTo(v2) > 0 || versionTo != null && versionTo.compareTo(v2) < 0) continue;
            filterred.add(v2);
        }
        return filterred;
    }

    public static Schema loadFromStream(InputStream stream, String source, String normSchemaName, Version normVersion) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Schema schema = (Schema)unmarshaller.unmarshal(stream);
            schema.normalize(source, normSchemaName, normVersion);
            Schema schema2 = schema;
            return schema2;
        }
        catch (Throwable e2) {
            throw new Exception(Nat.x("%1 nie je korektn\u00fd form\u00e1t sch\u00e9my %2", source, normSchemaName), e2);
        }
        finally {
            SchemaAccessorXml.closeSafeStream(stream);
        }
    }

    private static void closeSafeStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeSafeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Version extractVersionFromFileName(String schemaName, String fileName) {
        String starts;
        String h2 = fileName.toLowerCase();
        if (!h2.startsWith(starts = schemaName.toLowerCase() + "_")) {
            return null;
        }
        if (!(h2 = h2.substring(starts.length())).endsWith(XML_EXT)) {
            return null;
        }
        h2 = h2.substring(0, h2.length() - XML_EXT.length());
        h2 = h2.replace('_', '.');
        Version version = null;
        try {
            version = new Version(h2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    public static void save(Schema schema, File file) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)schema, file);
    }

    public static String getFileName(String schemaName, Version version) {
        return schemaName + "_" + version.format(2, '_') + XML_EXT;
    }
}

