/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import tangram.dm.Column;
import tangram.dm.Difference;
import tangram.dm.External;
import tangram.dm.Index;
import tangram.dm.Schema;
import tangram.dm.SchemaAccessorSql;
import tangram.dm.SchemaAccessorXml;
import tangram.dm.SchemaInfo;
import tangram.dm.Script;
import tangram.dm.Table;
import tangram.dm.Version;
import tangram.library.Nat;
import tangram.library.TngConnection;

public abstract class SchemaConverter {
    protected Schema schema;
    protected TngConnection connection;
    protected ArrayList<PhysTable> physTables = new ArrayList();
    protected HashMap<String, PhysTable> indexPhysTables = new HashMap();
    protected ArrayList<Difference> differences = new ArrayList();
    protected static final int STEP_CREATE = 1;
    protected static final int STEP_CLEAN_REPAIR = 2;
    protected static final int STEP_CONVERT = 4;
    protected static final int STEP_FINISH = 8;
    protected HashMap<String, Column> indexPhysColumns = new HashMap();
    private ArrayList<String> commands = new ArrayList();
    private static final String TNG_CONV_PACKAGE_HEADER = "CREATE OR REPLACE PACKAGE TNG_CONV AS\nFUNCTION ToNumber(str IN VARCHAR2) RETURN NUMBER;\nFUNCTION ToDate(str IN VARCHAR2) RETURN DATE;\nFUNCTION ToTimestamp(str IN VARCHAR2) RETURN TIMESTAMP;\nFUNCTION LongAsClob(tablename IN VARCHAR2,columnname IN VARCHAR2,prowid IN ROWID) RETURN CLOB;\nFUNCTION LongAsVarchar(tablename IN VARCHAR2,columnname IN VARCHAR2,prowid IN ROWID) RETURN VARCHAR2;\nEND TNG_CONV;";
    private static final String TNG_CONV_PACKAGE_BODY = "CREATE OR REPLACE\nPACKAGE BODY TNG_CONV AS\nFUNCTION ToNumber(str IN VARCHAR2) RETURN NUMBER AS\n BEGIN\n  RETURN TO_NUMBER(str);\n  EXCEPTION WHEN value_error THEN RETURN NULL;\n END ToNumber;\nFUNCTION ToDate(str IN VARCHAR2) RETURN DATE AS\n BEGIN\n  RETURN TO_DATE(str);\n  EXCEPTION WHEN value_error THEN RETURN NULL;\n END ToDate;\nFUNCTION ToTimestamp(str IN VARCHAR2) RETURN TIMESTAMP AS\n BEGIN\n  RETURN TO_TIMESTAMP(str);\n  EXCEPTION WHEN value_error THEN RETURN NULL;\n END ToTimestamp;\nFUNCTION LongAsClob(tablename IN VARCHAR2,columnname IN VARCHAR2,prowid IN ROWID) RETURN CLOB AS\n longValue LONG;\n BEGIN\n  EXECUTE IMMEDIATE 'SELECT '||columnname||' FROM '||tablename||' WHERE rowid=:prowid' INTO longValue USING prowid;\n  RETURN longValue;\n END LongAsClob;\nFUNCTION LongAsVarchar(tablename IN VARCHAR2,columnname IN VARCHAR2,prowid IN ROWID) RETURN VARCHAR2 AS\n longValue LONG; stringValue VARCHAR2(4000);\n BEGIN\n  EXECUTE IMMEDIATE 'SELECT '||columnname||' FROM '||tablename||' WHERE rowid=:prowid' INTO longValue USING prowid;\n  stringValue:=SUBSTR(longValue,1,4000);\n  RETURN stringValue;\n END LongAsVarchar;\nEND TNG_CONV;";

    protected abstract void catchException(Throwable var1) throws Exception;

    protected abstract void canRepair() throws Exception;

    protected abstract void progressInit(int var1);

    protected abstract void progressNext() throws Exception;

    protected abstract void log(String var1, int var2);

    public void create(TngConnection connection, String dirDM, String project, Version version) throws Exception {
        if (!connection.isSchemaEmpty()) {
            throw new Exception(Nat.x("Sch\u00e9ma %1 nie je pr\u00e1zdna, nie je mo\u017en\u00e9 sch\u00e9mu vytvori\u0165 pod\u013ea \u0161abl\u00f3ny %2 %3", connection.getSchemaConnected(), project, version));
        }
        File fileDM = SchemaAccessorXml.findZipFile(dirDM, project);
        if (fileDM == null) {
            throw new Exception(Nat.x("Nebol n\u00e1jden\u00fd s\u00fabor \u0161trukt\u00fary %1", dirDM + File.separator + project + ".dm"));
        }
        Schema schema = SchemaAccessorXml.loadFromZipZile(fileDM, project, version);
        SchemaAccessorXml.extendByCustom(schema, dirDM);
        this.create(connection, schema);
    }

    public void create(TngConnection connection, Schema schema) throws Exception {
        this.connection = connection;
        this.schema = schema;
        this.log(Nat.x("Vytvorenie sch\u00e9my %1 %2", schema.name, schema.version), 0);
        this.log(Nat.x("Pripojenie na ORACLE %1.%2.%3", connection.getHost(), connection.getService(), connection.getSchemaConnected()), 1);
        this.progressInit(this.calcProgressCount(9) + 1);
        this.createTables();
        this.insertSchemaVersion();
        this.finish();
        this.log(Nat.x("Vytvorenie sch\u00e9my ukon\u010den\u00e9"), 0);
    }

    public void repair(TngConnection connection, String dirDM) throws Exception {
        SchemaInfo physSchemaInfo = SchemaAccessorSql.readSchemaInfo(connection);
        File fileDM = SchemaAccessorXml.findZipFile(dirDM, physSchemaInfo.project);
        if (fileDM == null) {
            throw new Exception(Nat.x("Nebol n\u00e1jden\u00fd s\u00fabor \u0161trukt\u00fary %1", dirDM + File.separator + physSchemaInfo.project + ".dm"));
        }
        Schema schema = SchemaAccessorXml.loadFromZipZile(fileDM, physSchemaInfo.project, physSchemaInfo.version);
        SchemaAccessorXml.extendByCustom(schema, dirDM);
        this.repair(connection, physSchemaInfo, schema);
    }

    public void repair(TngConnection connection, SchemaInfo physSchemaInfo, Schema schema) throws Exception {
        this.connection = connection;
        this.schema = schema;
        this.log(Nat.x("Oprava sch\u00e9my %1 %2", physSchemaInfo.project, physSchemaInfo.version), 0);
        this.log(Nat.x("Pripojenie na ORACLE %1.%2.%3", connection.getHost(), connection.getService(), connection.getSchemaConnected()), 1);
        this.readTables();
        this.compare();
        this.progressInit(this.calcProgressCount(10));
        this.cleanAndRepair();
        this.finish();
        this.log(Nat.x("Oprava sch\u00e9my ukon\u010den\u00e1"), 0);
    }

    public ArrayList<Schema> loadUpgradeSchemas(File fileDM, SchemaInfo physSchemaInfo, Version versionTo, String dirDM) throws Exception {
        ArrayList<Version> versions = SchemaAccessorXml.getVersionsFromZipFile(fileDM, physSchemaInfo.project, physSchemaInfo.version, versionTo);
        if (versions.size() < 2) {
            throw new Exception(Nat.x("Neboli n\u00e1jden\u00e9 XML \u0161abl\u00f3ny pre %1 vo verzi\u00e1ch %2 a\u017e %3 v s\u00fabore \u0161trukt\u00fary %4", physSchemaInfo.project, physSchemaInfo.version, versionTo, fileDM.getAbsolutePath()));
        }
        if (versions.get(0).compareTo(physSchemaInfo.version) != 0) {
            throw new Exception(Nat.x("Nebola n\u00e1jden\u00e1 XML \u0161abl\u00f3na %1 v s\u00fabore \u0161trukt\u00fary %2", SchemaAccessorXml.getFileName(physSchemaInfo.project, physSchemaInfo.version), fileDM.getAbsolutePath()));
        }
        if (versions.get(versions.size() - 1).compareTo(versionTo) != 0) {
            throw new Exception(Nat.x("Nebola n\u00e1jden\u00e1 XML \u0161abl\u00f3na %1 v s\u00fabore \u0161trukt\u00fary %2", SchemaAccessorXml.getFileName(physSchemaInfo.project, versionTo), fileDM.getAbsolutePath()));
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>(versions.size());
        Schema lastSchema = null;
        for (int i2 = 0; i2 < versions.size(); ++i2) {
            Schema schema = SchemaAccessorXml.loadFromZipZile(fileDM, physSchemaInfo.project, versions.get(i2));
            if (dirDM != null) {
                SchemaAccessorXml.extendByCustom(schema, dirDM);
            }
            if (lastSchema != null && lastSchema.version.compareTo(schema.version) >= 0) {
                throw new Exception(Nat.x("Poradie XML \u0161abl\u00f3n nie je usporiadan\u00e9 pod\u013ea verzie"));
            }
            lastSchema = schema;
            schemas.add(schema);
        }
        return schemas;
    }

    public void upgrade(TngConnection connection, String dirDM, Version versionTo) throws Exception {
        SchemaInfo physSchemaInfo = SchemaAccessorSql.readSchemaInfo(connection);
        if (versionTo.compareTo(physSchemaInfo.version) <= 0) {
            throw new Exception(Nat.x("Aktu\u00e1lna verzia sch\u00e9my %1 je %2, upgrade na verziu %3 nie je mo\u017en\u00fd", physSchemaInfo.project, physSchemaInfo.version, versionTo));
        }
        File fileDM = SchemaAccessorXml.findZipFile(dirDM, physSchemaInfo.project);
        if (fileDM == null) {
            throw new Exception(Nat.x("Nebol n\u00e1jden\u00fd s\u00fabor \u0161trukt\u00fary %1", dirDM + File.separator + physSchemaInfo.project + ".dm"));
        }
        ArrayList<Schema> schemas = this.loadUpgradeSchemas(fileDM, physSchemaInfo, versionTo, dirDM);
        this.upgrade(connection, physSchemaInfo, schemas);
    }

    public void upgrade(TngConnection connection, SchemaInfo physSchemaInfo, ArrayList<Schema> schemas) throws Exception {
        this.connection = connection;
        this.schema = schemas.get(0);
        if (schemas.size() < 2) {
            throw new Exception(Nat.x("Upgrade sch\u00e9my vy\u017eaduje aktu\u00e1lnu a cie\u013eov\u00fa XML \u0161abl\u00f3nu"));
        }
        Schema lastSchema = schemas.get(schemas.size() - 1);
        this.log(Nat.x("Upgrade sch\u00e9my %1 %2 (z %3 na %4)", physSchemaInfo.project, physSchemaInfo.version, this.schema.version, lastSchema.version), 0);
        this.log(Nat.x("Pripojenie na ORACLE %1.%2.%3", connection.getHost(), connection.getService(), connection.getSchemaConnected()), 1);
        this.readTables();
        this.compare();
        boolean reloadPhys = this.differences.size() != 0;
        this.progressInit(this.calcProgressCount(2));
        this.cleanAndRepair();
        for (int i2 = 1; i2 < schemas.size(); ++i2) {
            this.schema = schemas.get(i2);
            if (reloadPhys) {
                this.readTables();
            } else {
                this.setUnusedTables();
            }
            reloadPhys = true;
            this.compare();
            int stepFinish = i2 == schemas.size() - 1 ? 8 : 0;
            this.progressInit(this.calcProgressCount(4 | stepFinish) + 1);
            this.convert();
            this.insertSchemaVersion();
        }
        this.finish();
        this.log(Nat.x("Upgrade sch\u00e9my ukon\u010den\u00fd"), 0);
    }

    protected void cleanAndRepair() throws Exception {
        this.canRepair();
        this.clean();
        this.log(Nat.x("Vytvorenie konverzn\u00e9ho bal\u00edka"), 1);
        this.progressNext();
        this.execDDL(TNG_CONV_PACKAGE_HEADER);
        this.execDDL(TNG_CONV_PACKAGE_BODY);
        this.log(Nat.x("Vytvorenie konverzn\u00e9ho bal\u00edka ukon\u010den\u00e9"), 1);
        if (this.differences.size() != 0) {
            this.log(Nat.x("Oprava \u0161trukt\u00fary %1", this.schema.version), 1);
            for (int i2 = 0; i2 < this.differences.size(); ++i2) {
                this.progressNext();
                this.repair(this.differences.get(i2), 0);
            }
            this.log(Nat.x("Oprava \u0161trukt\u00fary ukon\u010den\u00e1"), 1);
        }
    }

    protected void convert() throws Exception {
        int i2;
        this.log(Nat.x("Konverzia \u0161trukt\u00fary na %1", this.schema.version), 1);
        this.log(Nat.x("Roz\u0161\u00edrenie \u0161trukt\u00fary"), 2);
        for (i2 = 0; i2 < this.differences.size(); ++i2) {
            this.progressNext();
            this.repair(this.differences.get(i2), 1);
        }
        this.log(Nat.x("Konverzn\u00e9 skripty"), 2);
        for (i2 = 0; i2 < this.schema.scripts.size(); ++i2) {
            this.progressNext();
            Script script = this.schema.scripts.get(i2);
            if (!script.conversion) continue;
            this.runScript(script);
        }
        this.log(Nat.x("Komprim\u00e1cia \u0161trukt\u00fary"), 2);
        for (i2 = 0; i2 < this.differences.size(); ++i2) {
            this.progressNext();
            this.repair(this.differences.get(i2), 2);
        }
        this.log(Nat.x("Konverzia \u0161trukt\u00fary ukon\u010den\u00e1"), 1);
    }

    protected void compare() throws Exception {
        int i2;
        this.log(Nat.x("Porovnanie \u0161trukt\u00fary so \u0161abl\u00f3nou"), 1);
        this.differences.clear();
        for (i2 = 0; i2 < this.schema.tables.size(); ++i2) {
            this.compareTable(this.schema.tables.get(i2));
        }
        for (i2 = 0; i2 < this.physTables.size(); ++i2) {
            this.unusedPhysTable(this.physTables.get(i2));
        }
        this.log(Nat.x("Porovnanie \u0161trukt\u00fary so \u0161abl\u00f3nou ukon\u010den\u00e9"), 1);
    }

    protected void clean() throws Exception {
        int i2;
        this.log(Nat.x("\u010cistenie sch\u00e9my"), 1);
        ArrayList<String> names = new ArrayList<String>();
        for (i2 = 0; i2 < this.physTables.size(); ++i2) {
            int ii;
            this.progressNext();
            PhysTable physTable = this.physTables.get(i2);
            if (this.isExternal(physTable.name, "TABLE")) continue;
            this.log(Nat.x("\u010cistenie tabu\u013eky %1", physTable.name), 2);
            SchemaAccessorSql.readTableIndexes(this.connection, physTable.name, names);
            for (ii = 0; ii < names.size(); ++ii) {
                this.dropIndex(names.get(ii));
            }
            SchemaAccessorSql.readTableTriggers(this.connection, physTable.name, names);
            for (ii = 0; ii < names.size(); ++ii) {
                this.dropTrigger(names.get(ii));
            }
        }
        this.log(Nat.x("Zmazanie bal\u00edkov"), 2);
        SchemaAccessorSql.readPackages(this.connection, names);
        for (i2 = 0; i2 < names.size(); ++i2) {
            this.dropPackage(names.get(i2));
        }
        this.log(Nat.x("\u010cistenie sch\u00e9my ukon\u010den\u00e9"), 1);
    }

    protected void createTables() throws Exception {
        this.log(Nat.x("Vytvorenie tabuliek"), 1);
        for (int i2 = 0; i2 < this.schema.tables.size(); ++i2) {
            this.progressNext();
            Table table = this.schema.tables.get(i2);
            this.log(Nat.x("Vytvorenie tabu\u013eky %1", table.name), 2);
            this.execDDL(SchemaAccessorSql.getTableDDL(table));
        }
        this.log(Nat.x("Vytvorenie tabuliek ukon\u010den\u00e9"), 1);
    }

    protected void finish() throws Exception {
        int i2;
        this.log(Nat.x("Finaliz\u00e1cia \u0161trukt\u00fary"), 1);
        this.log(Nat.x("Finaliza\u010dn\u00e9 skripty"), 2);
        for (i2 = 0; i2 < this.schema.scripts.size(); ++i2) {
            this.progressNext();
            Script script = this.schema.scripts.get(i2);
            if (script.conversion) continue;
            this.runScript(script);
        }
        for (i2 = 0; i2 < this.schema.tables.size(); ++i2) {
            this.progressNext();
            Table table = this.schema.tables.get(i2);
            this.log(Nat.x("Vytvorenie indexov pre tabu\u013eku %1", table.name), 2);
            for (int ii = 0; ii < table.indexes.size(); ++ii) {
                this.createIndex(table.name, table.indexes.get(ii));
            }
        }
        this.log(Nat.x("Finaliz\u00e1cia \u0161trukt\u00fary ukon\u010den\u00e1"), 1);
    }

    protected void unusedPhysTable(PhysTable physTable) {
        if (physTable.existsInTemplate) {
            return;
        }
        if (this.isExternal(physTable.name, "TABLE")) {
            return;
        }
        this.diffDropTable(physTable.name);
    }

    protected void compareTable(Table table) {
        PhysTable physTable = this.indexPhysTables.get(table.name);
        if (physTable == null) {
            this.diffNewTable(table);
        } else {
            physTable.existsInTemplate = true;
            this.compareColumns(table, physTable);
        }
    }

    protected void compareColumns(Table table, PhysTable physTable) {
        Column physColumn;
        int i2;
        this.indexPhysColumns.clear();
        for (i2 = 0; i2 < physTable.columns.size(); ++i2) {
            physColumn = (Column)physTable.columns.get(i2);
            this.indexPhysColumns.put(physColumn.name, physColumn);
        }
        for (i2 = 0; i2 < table.columns.size(); ++i2) {
            Column column = table.columns.get(i2);
            Column physColumn2 = this.indexPhysColumns.get(column.name);
            if (physColumn2 == null) {
                this.diffNewColumn(table.name, column);
                continue;
            }
            this.indexPhysColumns.put(physColumn2.name, null);
            this.compareColumn(table.name, column, physColumn2);
        }
        for (i2 = 0; i2 < physTable.columns.size(); ++i2) {
            physColumn = (Column)physTable.columns.get(i2);
            Column exists = this.indexPhysColumns.get(physColumn.name);
            if (exists == null) continue;
            this.diffDropColumn(physTable.name, physColumn);
        }
    }

    protected boolean isExternal(String name, String type) {
        for (int i2 = 0; i2 < this.schema.externals.size(); ++i2) {
            External ext = this.schema.externals.get(i2);
            if (!ext.name.equals(name) || !ext.type.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected void setUnusedTables() {
        for (int i2 = 0; i2 < this.physTables.size(); ++i2) {
            this.physTables.get(i2).existsInTemplate = false;
        }
    }

    protected void readTables() throws Exception {
        this.log(Nat.x("Anal\u00fdza SQL \u0161trukt\u00fary"), 1);
        this.physTables.clear();
        this.indexPhysTables.clear();
        ArrayList<String> names = new ArrayList<String>();
        SchemaAccessorSql.readTables(this.connection, names);
        this.progressInit(names.size());
        for (int i2 = 0; i2 < names.size(); ++i2) {
            this.progressNext();
            this.readTable(names.get(i2));
        }
        this.log(Nat.x("Anal\u00fdza SQL \u0161trukt\u00fary ukon\u010den\u00e1"), 1);
    }

    protected void readTable(String tableName) throws Exception {
        this.log(Nat.x("Zistenie \u0161trukt\u00fary tabu\u013eky %1", tableName), 2);
        PhysTable table = new PhysTable();
        table.name = tableName;
        SchemaAccessorSql.readTableColumns(this.connection, tableName, table.columns, false);
        this.physTables.add(table);
        this.indexPhysTables.put(table.name, table);
    }

    protected void diffDropTable(String tableName) {
        Difference d2 = new Difference();
        d2.action = 2;
        d2.modifiedFlags = 0;
        d2.tableName = tableName;
        d2.table = null;
        d2.column = null;
        d2.physColumn = null;
        d2.infoText = Nat.x("Zmazanie tabu\u013eky %1", d2.tableName);
        this.addDifference(d2);
        this.log(d2.infoText, 2);
    }

    protected void diffNewTable(Table table) {
        Difference d2 = new Difference();
        d2.action = 1;
        d2.modifiedFlags = 0;
        d2.tableName = table.name;
        d2.table = table;
        d2.column = null;
        d2.physColumn = null;
        d2.infoText = Nat.x("Pridanie tabu\u013eky %1", table.name);
        this.addDifference(d2);
        this.log(d2.infoText, 2);
    }

    protected void diffNewColumn(String tableName, Column column) {
        Difference d2 = new Difference();
        d2.action = 3;
        d2.modifiedFlags = 0;
        d2.tableName = tableName;
        d2.table = null;
        d2.column = column;
        d2.physColumn = null;
        d2.infoText = Nat.x("Pridanie st\u013apca %1.%2 %3", tableName, column.name, this.getTemplColumnData(column));
        this.addDifference(d2);
        this.log(d2.infoText, 2);
    }

    protected void diffDropColumn(String tableName, Column physColumn) {
        Difference d2 = new Difference();
        d2.action = 4;
        d2.modifiedFlags = 0;
        d2.tableName = tableName;
        d2.table = null;
        d2.column = null;
        d2.physColumn = physColumn;
        d2.infoText = Nat.x("Zmazanie st\u013apca %1.%2 %3", tableName, physColumn.name, this.getPhysColumnData(physColumn));
        this.addDifference(d2);
        this.log(d2.infoText, 2);
        if (physColumn.name.startsWith("#")) {
            throw new IllegalArgumentException(Nat.x("Posledn\u00e1 konverzia neprebehla \u00faspe\u0161ne. V tabu\u013eke %1 existuje pomocn\u00fd st\u013apec %2. St\u013apec je potrebn\u00e9 zmaza\u0165 alebo premenova\u0165 na p\u00f4vodn\u00fd st\u013apec, pod\u013ea toho, \u010di existuje p\u00f4vodn\u00fd st\u013apec a \u010di obsahuje d\u00e1ta.", tableName, physColumn.name));
        }
    }

    protected void compareColumn(String tableName, Column column, Column physColumn) {
        int flags = Difference.getModifiedFlags(column, physColumn);
        if (flags == 0) {
            return;
        }
        Difference d2 = new Difference();
        d2.action = 5;
        d2.modifiedFlags = flags;
        d2.tableName = tableName;
        d2.table = null;
        d2.column = column;
        d2.physColumn = physColumn;
        d2.infoText = Nat.x("Zmena st\u013apca %1.%2 %3 -> %4", tableName, column.name, this.getPhysColumnData(physColumn), this.getTemplColumnData(column));
        this.addDifference(d2);
        this.log(d2.infoText, 2);
    }

    protected void addDifference(Difference d2) {
        this.differences.add(d2);
    }

    protected String getPhysColumnData(Column column) {
        StringBuilder columnData = new StringBuilder();
        columnData.setLength(0);
        SchemaAccessorSql.addColumnDDL(columnData, column.type, column.precision, column.scale, column.defaultValue, column.notNull);
        return columnData.toString();
    }

    protected String getTemplColumnData(Column column) {
        StringBuilder columnData = new StringBuilder();
        columnData.setLength(0);
        SchemaAccessorSql.addColumnDDL(columnData, SchemaAccessorSql.columnTypeToPhys(column.type), column.precision, column.scale, column.defaultValue, column.notNull);
        return columnData.toString();
    }

    protected void insertSchemaVersion() throws Exception {
        try {
            this.progressNext();
            if (SchemaAccessorSql.existsTable(this.connection, "VERZIE")) {
                this.log(Nat.x("Z\u00e1pis verzie %1 %2 do \u0161trukt\u00fary", this.schema.name, this.schema.version), 3);
                this.execDDL("INSERT INTO verzie(projekt,verzia,xo,xd) VALUES('" + this.schema.name + "'," + this.schema.version + ",USER,SYSDATE)");
            }
        }
        catch (Throwable e2) {
            this.catchException(e2);
        }
    }

    protected void repair(Difference diff, int repairMode) throws Exception {
        this.commands.clear();
        diff.repairDDL(repairMode, this.commands);
        if (this.commands.size() == 0) {
            return;
        }
        this.log(diff.toString(), 3);
        try {
            for (int i2 = 0; i2 < this.commands.size(); ++i2) {
                String cmd = this.commands.get(i2);
                this.log(cmd, 4);
                this.connection.exec(cmd);
            }
        }
        catch (Throwable e2) {
            this.catchException(e2);
        }
    }

    protected void createIndex(String tableName, Index index) throws Exception {
        this.log(Nat.x("Vytvorenie indexu %1_%2", tableName, index.name), 3);
        this.execDDL(SchemaAccessorSql.getIndexDDL(tableName, index));
    }

    protected void dropIndex(String index) throws Exception {
        this.log(Nat.x("Zmazanie indexu %1", this.getNameOnly(index)), 3);
        this.execDDL("DROP INDEX " + this.getOwnerAndNameSql(index));
    }

    protected void dropTrigger(String trigger) throws Exception {
        this.log(Nat.x("Zmazanie triggeru %1", this.getNameOnly(trigger)), 3);
        this.execDDL("DROP TRIGGER " + this.getOwnerAndNameSql(trigger));
    }

    protected String getNameOnly(String ownerAndName) {
        int n2 = ownerAndName.indexOf(46);
        if (n2 < 0) {
            return ownerAndName;
        }
        return ownerAndName.substring(n2 + 1);
    }

    protected String getOwnerAndNameSql(String ownerAndName) {
        int n2 = ownerAndName.indexOf(46);
        if (n2 < 0) {
            return "\"" + ownerAndName + "\"";
        }
        String owner = ownerAndName.substring(0, n2 + 1);
        String name = ownerAndName.substring(n2 + 1);
        return owner + "\"" + name + "\"";
    }

    protected void dropPackage(String pck) throws Exception {
        if (this.isExternal(pck, "PACKAGE")) {
            return;
        }
        this.log(Nat.x("Zmazanie bal\u00edka %1", pck), 3);
        this.execDDL("DROP PACKAGE \"" + pck + "\"");
    }

    protected void runScript(Script script) throws Exception {
        this.log(Nat.x("Vykonanie skriptu %1", script.name), 3);
        this.execDDLWithCommit(script.definition);
    }

    protected void execDDL(String ddl) throws Exception {
        try {
            this.log(ddl, 4);
            this.connection.exec(ddl);
        }
        catch (Throwable e2) {
            this.catchException(e2);
        }
    }

    protected void execDDLWithCommit(String ddl) throws Exception {
        try {
            this.log(ddl, 4);
            this.connection.exec(ddl);
            this.log("COMMIT", 4);
            this.connection.commit();
        }
        catch (Throwable e2) {
            this.log("ROLLBACK", 4);
            this.connection.rollback();
            this.catchException(e2);
        }
    }

    protected int calcProgressCount(int stepFlags) {
        int count = 0;
        if ((stepFlags & 1) != 0) {
            count += this.schema.tables.size();
        }
        if ((stepFlags & 2) != 0) {
            count += this.physTables.size() + this.differences.size() + 1;
        }
        if ((stepFlags & 4) != 0) {
            count += this.differences.size() + this.schema.scripts.size() + this.differences.size();
        }
        if ((stepFlags & 8) != 0) {
            count += this.schema.tables.size() + this.schema.scripts.size();
        }
        return count;
    }

    protected class PhysTable {
        private String name;
        private boolean existsInTemplate;
        private ArrayList<Column> columns = new ArrayList();

        protected PhysTable() {
        }
    }
}

