/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm.buffer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import tangram.dm.Column;
import tangram.dm.SchemaAccessorSql;
import tangram.dm.Table;
import tangram.library.TngConnection;
import tangram.library.TngSqlUtilities;
import tangram.library.TngUtilities;

public class TngBufferLoader {
    private TngConnection conn;
    private boolean hasXx = false;
    private static String[] keywords = new String[]{"assert", "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (TngConnection connection = null;){
            String[] schemas;
            connection = new TngConnection();
            connection.setUser("eko");
            connection.setPassword("eko");
            connection.connect();
            for (String schema : schemas = new String[]{"eko"}) {
                connection.changeSchema(schema);
                TngBufferLoader loader = new TngBufferLoader();
                loader.setData(connection);
                loader.load();
            }
        }
    }

    public void setData(TngConnection conn) {
        this.conn = conn;
    }

    public void load() throws Exception {
        ArrayList<String> tables = new ArrayList<String>();
        SchemaAccessorSql.readTables(this.conn, tables);
        for (String table : tables) {
            this.loadTable(table);
        }
    }

    private void loadTable(String tableName) throws Exception {
        this.hasXx = false;
        Table table = SchemaAccessorSql.readTable(this.conn, tableName);
        StringBuilder java = new StringBuilder();
        java.append("package tangram.dm.buffer." + this.conn.getSchemaConnected().toLowerCase() + ";\n");
        java.append("\n");
        java.append("import java.util.ArrayList;\n");
        java.append("import java.util.List;\n");
        java.append("\n");
        java.append("import tangram.dm.Column;\n");
        java.append("import tangram.dm.buffer.TngDmBuffer;\n");
        java.append("import tangram.dm.buffer.TngDmField;\n");
        java.append("import tangram.dm.buffer.TngDmFieldDate;\n");
        java.append("import tangram.dm.buffer.TngDmFieldDecimal;\n");
        java.append("import tangram.dm.buffer.TngDmFieldInt;\n");
        java.append("import tangram.dm.buffer.TngDmFieldString;\n");
        java.append("import tangram.library.TngSys;\n");
        java.append("\npublic class " + TngUtilities.strCapitalize(tableName) + " extends TngDmBuffer\n");
        java.append("{\n");
        for (Column column : table.columns) {
            String columnStr = this.loadColumn(column);
            if (TngUtilities.isEmpty(columnStr)) continue;
            java.append(columnStr + "\n");
        }
        ArrayList<String> indeces = new ArrayList<String>();
        if (this.hasXx) {
            indeces.add("xx");
        } else {
            String[] idxs = TngSqlUtilities.readPrimaryColumns(this.conn, this.conn.getUserConnected(), tableName);
            if (idxs != null) {
                indeces.addAll(Arrays.asList(idxs));
            }
        }
        java.append("\n  public " + TngUtilities.strCapitalize(tableName) + "()\n");
        java.append("  {\n");
        java.append("    super();\n");
        java.append("    afterConstruct();\n");
        java.append("  }\n");
        java.append("\n  @Override\n");
        java.append("  public String getTableName()\n");
        java.append("  {\n");
        java.append("    return " + (this.conn.getSchema().equalsIgnoreCase("TNGSYS") ? "TngSys.SCHEMA_NAME+\"." : "\"") + tableName.toLowerCase() + "\";\n");
        java.append("  }\n");
        java.append("\n  @Override\n");
        java.append("  public List<TngDmField> getPrimaryFields()\n");
        java.append("  {\n");
        java.append("    List<TngDmField> primaryFields=new ArrayList<TngDmField>();\n");
        if (indeces.size() == 0) {
            java.append("    //TODO primaryFields.add(null);\n");
        } else {
            for (String index : indeces) {
                java.append("    primaryFields.add(" + index.toLowerCase() + ");\n");
            }
        }
        java.append("    return primaryFields;\n");
        java.append("  }\n");
        java.append("}\n");
        this.writeFile(tableName, java.toString());
    }

    private String loadColumn(Column column) throws Exception {
        String columnName;
        String columnNameKeyword = columnName = column.name.toLowerCase();
        if (TngBufferLoader.isKeyword(columnName)) {
            columnNameKeyword = columnNameKeyword + "_K_";
        }
        if (columnName.equalsIgnoreCase("xx")) {
            this.hasXx = true;
        }
        String columnType = column.type;
        int columnPrecision = column.precision;
        int columnScale = column.scale;
        boolean notNull = column.notNull;
        String columnDefault = column.defaultValue;
        StringBuilder columnStr = new StringBuilder();
        columnStr.append("  public ");
        String field = "";
        field = columnType.equals("NUMBER") ? (columnScale == 0 ? "TngDmFieldInt " + columnNameKeyword + "=new TngDmFieldInt(\"" + columnName + "\",null,null,Column.NUMBER," + columnPrecision + "," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");" : "TngDmFieldDecimal " + columnNameKeyword + "=new TngDmFieldDecimal(\"" + columnName + "\",null,null,Column.NUMBER," + columnPrecision + "," + columnScale + "," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");") : (columnType.equals("DATE") ? "TngDmFieldDate " + columnNameKeyword + "=new TngDmFieldDate(\"" + columnName + "\",null,null,Column.DATE," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");" : (columnType.equals("TIMESTAMP") ? "TngDmFieldDate " + columnNameKeyword + "=new TngDmFieldDate(\"" + columnName + "\",null,null,Column.TIMESTAMP," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");" : (columnType.equals("LONG") ? "TngDmFieldString " + columnNameKeyword + "=new TngDmFieldString(\"" + columnName + "\",null,null,Column.LONG," + columnPrecision + "," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");" : "TngDmFieldString " + columnNameKeyword + "=new TngDmFieldString(\"" + columnName + "\",null,null,Column.VARCHAR2," + columnPrecision + "," + notNull + "," + (columnDefault == null ? null : "\"" + columnDefault + "\"") + ");")));
        columnStr.append(field);
        return columnStr.toString();
    }

    private void writeFile(String table, String tableJava) throws Exception {
        File file = new File("../TngLib/src/tangram/dm/buffer/" + this.conn.getSchemaConnected().toLowerCase() + "/" + TngUtilities.strCapitalize(table) + ".java");
        FileUtils.writeStringToFile(file, tableJava);
    }

    private static boolean isKeyword(String text) {
        for (int i2 = 0; i2 < keywords.length; ++i2) {
            if (!text.equalsIgnoreCase(keywords[i2])) continue;
            return true;
        }
        return false;
    }
}

