/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm.buffer;

import java.util.HashMap;
import java.util.Map;
import tangram.dm.buffer.TngDmBuffer;
import tangram.exception.TngExceptionAbort;
import tangram.interfaces.TngProgressable;
import tangram.library.TngConnection;

public abstract class TngDmBufferCached<E extends TngDmBuffer, F extends TngDmBuffer> {
    private final Map<String, String> cache = new HashMap<String, String>();
    protected final Map<String, FCalc> fcalcs = new HashMap<String, FCalc>();

    public abstract E getParent();

    protected void cachePut(String key, String value) {
        this.cache.put(key, value);
    }

    protected String cacheGet(String key) {
        return this.cache.get(key);
    }

    protected void cacheRemove(String key) {
        this.cache.remove(key);
    }

    public void clearValues() {
        this.cache.clear();
        this.fcalcs.clear();
    }

    public void putValue(String key, String value, FCalc fcalc) {
        this.cachePut(key, value);
        if (!this.fcalcs.containsKey(key) || this.fcalcs.get(key) == null) {
            this.fcalcs.put(key, fcalc);
        }
    }

    public String getValue(TngConnection conn, String key) throws Exception {
        if (this.cache.containsKey(key)) {
            return this.cacheGet(key);
        }
        String value = this.loadValue(conn, key);
        this.cachePut(key, value);
        return value;
    }

    protected abstract void loadAll(TngConnection var1, TngProgressable var2) throws Exception;

    protected abstract String loadValue(TngConnection var1, String var2) throws Exception;

    protected abstract void saveValue(TngConnection var1, String var2, String var3) throws Exception;

    public void load(TngConnection conn, TngProgressable worker) throws Exception {
        this.loadAll(conn, worker);
    }

    public void save(TngConnection conn, TngProgressable worker) throws Exception {
        if (worker != null) {
            worker.setProgressMax(this.cache.size());
        }
        try {
            for (Map.Entry<String, String> entry : this.cache.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.saveValue(conn, key, value);
                if (worker == null) continue;
                worker.addProgressValue(1);
                if (!worker.isProgressCanceled()) continue;
                throw new TngExceptionAbort();
            }
            conn.commit();
        }
        catch (Exception e2) {
            conn.rollback();
            throw e2;
        }
    }

    public static enum FCalc {
        A,
        B,
        C;

    }
}

