/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm.buffer.eko.ext;

import java.util.ArrayList;
import java.util.List;
import tangram.dm.buffer.eko.Docdef;
import tangram.dm.buffer.eko.Tmp_uct;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class DocdefExt
extends Docdef {
    private static final char SIGN_PLUS = '+';
    private static final char SIGN_MINUS = '-';
    public static final char SIDE_MD = 'M';
    public static final char SIDE_DAL = 'D';
    private static final char VALUE_P = 'P';
    private static final char VALUE_O = 'O';
    private static final char VALUE_L = 'L';
    private static final char VALUE_Z = 'Z';
    private static final char VALUE_R = 'R';
    private final List<Def> defs = new ArrayList<Def>();
    private static final Tmp_uct tmpUctBuffer = new Tmp_uct();
    private static final StringBuilder queryBuilder = new StringBuilder();

    public List<Def> getDefs() {
        return this.defs;
    }

    public void setDefinitions() {
        this.defs.clear();
        String defValue = (String)this.def.getValue();
        if (TngUtilities.isEmpty(defValue)) {
            return;
        }
        String[] defTokens = TngUtilities.strTokenizeNotNull(defValue = defValue.replace(" ", ""), ',');
        if (defTokens.length == 0) {
            return;
        }
        for (String defToken : defTokens) {
            this.defs.add(Def.fromToken(defToken));
        }
    }

    public void validateDefinitions() throws TngException {
        for (Def def : this.defs) {
            String fieldValue = (String)this.field.getValue();
            if (def.sign == '\u0000' || def.sign != '+' && def.sign != '-') {
                throw new TngException(Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' nem\u00e1 zadan\u00e9 znamienko (%3 | &4)", def.token, fieldValue, Character.valueOf('+'), Character.valueOf('-')));
            }
            if (def.side != '\u0000' && def.side != 'M' && def.side != 'D') {
                throw new TngException(Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' ma nespr\u00e1vnu stranu (%3 | %4)", def.token, fieldValue, Character.valueOf('M'), Character.valueOf('D')));
            }
            if (def.value == '\u0000' || def.value != 'P' && def.value != 'O' && def.value != 'L' && def.value != 'Z' && def.value != 'R') {
                throw new TngException(Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' m\u00e1 nespr\u00e1vnu hodnotu (%3 | %4 | %5 | %6 | %7)", def.token, fieldValue, Character.valueOf('P'), Character.valueOf('O'), Character.valueOf('L'), Character.valueOf('Z'), Character.valueOf('R')));
            }
            if (def.side == '\u0000' && def.value == 'R') {
                throw new TngException(Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' m\u00e1 hodnotu R, ale nem\u00e1 zadan\u00fa stranu (%3 | %4)", def.token, fieldValue, Character.valueOf('M'), Character.valueOf('D')));
            }
            if (!TngUtilities.isEmpty(def.account)) continue;
            throw new TngException(Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' nem\u00e1 zadan\u00fd \u00fa\u010det", def.token, fieldValue));
        }
    }

    public static class Def {
        public String token;
        public char sign = (char)43;
        public char side;
        public char value;
        public String account;

        private static Def fromToken(String token) {
            Def def = new Def();
            def.token = token;
            def.resolveToken();
            return def;
        }

        private void resolveToken() {
            char valueChar;
            char sideChar;
            int pos = 0;
            char signChar = this.getCharAt(pos, new char[]{'+', '-'});
            if (signChar != '\u0000') {
                this.sign = signChar;
                ++pos;
            }
            if ((sideChar = this.getCharAt(pos, new char[]{'M', 'D'})) != '\u0000') {
                this.side = sideChar;
                ++pos;
            }
            if ((valueChar = this.getCharAt(pos, new char[]{'P', 'O', 'L', 'Z', 'R'})) != '\u0000') {
                this.value = valueChar;
                ++pos;
            }
            this.account = TngUtilities.strSubstrOrNull(this.token, pos);
        }

        private char getCharAt(int pos, char[] chars) {
            String defValue = this.token;
            if (TngUtilities.isEmpty(defValue)) {
                return '\u0000';
            }
            if (pos < 0 || pos >= defValue.length()) {
                return '\u0000';
            }
            char charAt = defValue.charAt(pos);
            for (char charr : chars) {
                if (charr != charAt) continue;
                return charAt;
            }
            return '\u0000';
        }

        public String generateQuery() {
            queryBuilder.setLength(0);
            queryBuilder.append("SELECT");
            queryBuilder.append(" MAX(" + tmpUctBuffer.typ.getFullName() + ")");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.pm.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.pd.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.om.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.od.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.lm.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.ld.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.zm.getFullName() + ",0))");
            queryBuilder.append(",SUM(NVL(" + tmpUctBuffer.zd.getFullName() + ",0))");
            queryBuilder.append(" FROM " + tmpUctBuffer.getTableName());
            queryBuilder.append(" WHERE " + TngConnection.simpleLike(tmpUctBuffer.ucet.getFullName(), this.account + "*"));
            return queryBuilder.toString();
        }

        public boolean isSignPlus() {
            return this.sign == '\u0000' || this.sign == '+';
        }

        public boolean isSignMinus() {
            return this.sign == '-';
        }

        public boolean hasSide() {
            return this.isSideMD() || this.isSideDAL();
        }

        public boolean isSideMD() {
            return this.side == 'M';
        }

        public boolean isSideDAL() {
            return this.side == 'D';
        }

        public boolean isValueP() {
            return this.value == 'P';
        }

        public boolean isValueO() {
            return this.value == 'O';
        }

        public boolean isValueL() {
            return this.value == 'L';
        }

        public boolean isValueZ() {
            return this.value == 'Z';
        }

        public boolean isValueR() {
            return this.value == 'R';
        }
    }
}

