/*
 * Decompiled with CFR 0.152.
 */
package tangram.exception;

import java.sql.SQLException;
import tangram.exception.TngException;
import tangram.library.Nat;

public class TngExceptionSql
extends TngException {
    private String sql;
    private Throwable origException;

    public TngExceptionSql(String message, String sql) {
        super(message);
        this.origException = null;
        this.sql = sql;
    }

    public TngExceptionSql(Throwable e2, String sql) {
        super(TngExceptionSql.messagePure(e2.getMessage()));
        this.origException = e2;
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public int getErrorCode() {
        if (this.origException instanceof SQLException) {
            SQLException er = (SQLException)this.origException;
            return er.getErrorCode();
        }
        return 0;
    }

    public boolean isUniqueViolation() {
        if (this.origException instanceof SQLException) {
            SQLException er = (SQLException)this.origException;
            return er.getErrorCode() == 1;
        }
        return false;
    }

    @Override
    public String toString() {
        String h2 = this.getClass().getName();
        if (this.origException != null) {
            h2 = this.origException.getClass().getName();
        }
        if (this.getMessage() != null) {
            h2 = h2 + ": " + this.getMessage();
        }
        if (this.sql != null) {
            h2 = h2 + "\n\n" + Nat.x("SQL pr\u00edkaz:") + "\n" + this.sql;
        }
        return h2;
    }

    private static String messagePure(String text) {
        if (text != null) {
            text = text.trim();
        }
        return text;
    }
}

