/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter.item;

import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.library.TngParams;
import tangram.library.TngUtilities;

public abstract class TngFilterItem<E>
implements Cloneable {
    protected String name;
    protected String label;
    protected boolean editable;
    protected boolean intervalable;
    protected boolean interval;
    protected boolean intervalDefault;
    protected E value;
    protected E valueA;
    protected E valueB;

    public abstract String valueToString(E var1);

    public abstract E valueFromString(String var1) throws Exception;

    public abstract String createFilterExpression();

    public abstract String createFilterDescription();

    public abstract TngFilterVisualizer createFilterVisualizer();

    public TngFilterItem(String name, String label, boolean intervalable, boolean interval) {
        this.name = name;
        this.label = label;
        this.intervalable = intervalable;
        this.intervalDefault = interval;
        this.editable = true;
        this.reset();
    }

    public TngFilterItem<E> clone() {
        try {
            return (TngFilterItem)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public E getValue() {
        return this.value;
    }

    public E getValueA() {
        return this.valueA;
    }

    public E getValueB() {
        return this.valueB;
    }

    public void reset() {
        this.value = null;
        this.valueA = null;
        this.valueB = null;
        this.interval = this.intervalDefault;
    }

    public void setValue(E value) {
        this.value = value;
        this.interval = false;
    }

    public void setValue() {
        this.setValue(null);
    }

    public void setInterval(E valueA, E valueB) {
        if (this.intervalable) {
            this.valueA = valueA;
            this.valueB = valueB;
            this.interval = true;
        }
    }

    public void setInterval() {
        this.setInterval(null, null);
    }

    public void setInterval(boolean interval) {
        this.interval = interval;
    }

    public boolean intervalable() {
        return this.intervalable;
    }

    public boolean isInterval() {
        return this.interval;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean hasValue() {
        return this.interval ? this.valueA != null || this.valueB != null : this.value != null;
    }

    public void save(TngParams params) {
        params = params.getSubParams(this.name);
        params.setString("value", this.valueToString(this.value));
        if (this.intervalable) {
            params.setString("valueA", this.valueToString(this.valueA));
            params.setString("valueB", this.valueToString(this.valueB));
            params.setBoolean("interval", this.interval);
        }
    }

    public void load(TngParams params) {
        try {
            params = params.getSubParams(this.name);
            this.value = this.valueFromString(params.getString("value", null));
            if (this.intervalable) {
                this.valueA = this.valueFromString(params.getString("valueA", null));
                this.valueB = this.valueFromString(params.getString("valueB", null));
                this.interval = params.getBoolean("interval", this.intervalDefault);
            }
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
            this.reset();
        }
    }

    public String toString() {
        String h2 = this.name + ": ";
        try {
            h2 = h2 + this.createFilterDescription();
        }
        catch (Throwable e2) {
            h2 = h2 + e2.toString();
        }
        return h2;
    }
}

