/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter.item;

import java.util.LinkedHashMap;
import tangram.filter.item.TngFilterItem;
import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.filter.visualizer.TngFilterVisualizerCombo;

public class TngFilterItemCombo
extends TngFilterItem<String> {
    private LinkedHashMap<Object, Object> values;
    private boolean useKeys = true;

    public TngFilterItemCombo(String name, String label, LinkedHashMap<Object, Object> values) {
        super(name, label, false, false);
        this.values = values;
        this.useKeys = true;
    }

    public TngFilterItemCombo(String name, String label, Object[] values) {
        super(name, label, false, false);
        this.values = new LinkedHashMap();
        for (Object val : values) {
            this.values.put(val, val);
        }
        this.useKeys = false;
    }

    public LinkedHashMap<Object, Object> getValues() {
        return this.values;
    }

    @Override
    public String valueToString(String value) {
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    @Override
    public String valueFromString(String value) throws Exception {
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    @Override
    public String createFilterExpression() {
        if (this.value == null) {
            return null;
        }
        Object o2 = this.values.get(this.value);
        if (o2 == null) {
            return null;
        }
        return this.name + "='" + (String)this.value + "'";
    }

    @Override
    public String createFilterDescription() {
        Object o2 = this.values.get(this.value);
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    @Override
    public TngFilterVisualizer createFilterVisualizer() {
        return new TngFilterVisualizerCombo(this.values, this.useKeys);
    }
}

