/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter.item;

import java.text.SimpleDateFormat;
import java.util.Date;
import tangram.filter.TngFilter;
import tangram.filter.item.TngFilterItem;
import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.filter.visualizer.TngFilterVisualizerDate;

public class TngFilterItemDate
extends TngFilterItem<Date> {
    private static SimpleDateFormat fmtDate = new SimpleDateFormat("dd.MM.yyyy");
    private boolean trunc;

    public TngFilterItemDate(String name, String label) {
        this(name, label, false);
    }

    public TngFilterItemDate(String name, String label, boolean trunc) {
        super(name, label, true, true);
        this.trunc = trunc;
    }

    @Override
    public String valueToString(Date value) {
        return value == null ? "" : fmtDate.format(value);
    }

    @Override
    public Date valueFromString(String value) throws Exception {
        if (value == null || value.length() == 0) {
            return null;
        }
        fmtDate.setLenient(false);
        return fmtDate.parse(value);
    }

    @Override
    public String createFilterExpression() {
        if (this.interval) {
            return TngFilter.filterDateInterval(this.getFieldName(), (Date)this.valueA, (Date)this.valueB);
        }
        return TngFilter.filterDate(this.getFieldName(), (Date)this.value);
    }

    @Override
    public String createFilterDescription() {
        if (this.interval) {
            return TngFilter.filterDateDescriptionInterval(this.label, (Date)this.valueA, (Date)this.valueB);
        }
        return TngFilter.filterDateDescription(this.label, (Date)this.value);
    }

    @Override
    public TngFilterVisualizer createFilterVisualizer() {
        return new TngFilterVisualizerDate();
    }

    private String getFieldName() {
        return this.trunc ? "trunc(" + this.name + ")" : this.name;
    }
}

