/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.FdfWriter;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.XfaForm;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import tangram.forms.TngFormExporter;
import tangram.forms.TngFormZipFile;
import tangram.forms.TngForms;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngFormExporterPdf
extends TngFormExporter {
    @Override
    protected String getFileExtension() {
        return "pdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportInner() throws Exception {
        TngFormZipFile formZipFile = TngForms.openFormZipFile();
        try {
            for (int i2 = 0; i2 < this.targetFiles.length; ++i2) {
                File targetFile = this.targetFiles[i2];
                this.worker.setProgressStatus(Nat.x("Vytv\u00e1ranie s\u00faboru %1", targetFile.getAbsolutePath()));
                String entryName = TngForms.getZipEntryName(this.formFiller.getDataAccessor().getFormat(), "_Original" + (i2 + 1), "pdf");
                InputStream sourcePdf = formZipFile.getZippedInputStream(entryName);
                this.exportToPdf(sourcePdf, targetFile);
            }
            Desktop.getDesktop().open(new File(this.pfdFileNameToFdf(this.targetFiles[0].getAbsolutePath())));
        }
        finally {
            TngForms.closeFormZipFile(formZipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportToPdf(InputStream sourcePdf, File targetFile) throws Exception {
        this.worker.setProgressStatus(Nat.x("Z\u00e1pis \u00fadajov do s\u00faboru %1", targetFile.getAbsolutePath()));
        PdfStamper pdfStamper = null;
        String javaScript = null;
        try {
            PdfReader pdfReader = new PdfReader(sourcePdf);
            javaScript = pdfReader.getJavaScript();
            pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(targetFile), '\u0000', true);
            this.loadData(pdfStamper, targetFile);
            pdfStamper.addJavaScript(TngUtilities.strExt(javaScript, "", "this.calculateNow();"));
            pdfStamper.setFullCompression();
            pdfStamper.close();
            pdfStamper = null;
            this.closeSafe(pdfStamper);
        }
        catch (Throwable throwable) {
            this.closeSafe(pdfStamper);
            throw throwable;
        }
    }

    protected void loadData(PdfStamper pdfStamper, File targetFile) throws Exception {
        AcroFields acroFields = pdfStamper.getAcroFields();
        XfaForm xfa = acroFields.getXfa();
        if (xfa.isXfaPresent()) {
            this.loadDataXfa(xfa);
        } else {
            this.loadDataAcrofields(acroFields);
            FdfWriter fdfWriter = new FdfWriter();
            fdfWriter.setFile(targetFile.getName());
            acroFields.exportAsFdf(fdfWriter);
            fdfWriter.writeTo(new FileOutputStream(this.pfdFileNameToFdf(targetFile.getAbsolutePath())));
        }
    }

    private String pfdFileNameToFdf(String pdfFileName) {
        return pdfFileName.replace("." + this.getFileExtension(), ".fdf");
    }

    protected void loadDataXfa(XfaForm xfaForm) throws Exception {
        TngForm form = TngForms.loadStruct(this.formFiller.getDataAccessor().getFormat());
        List<TngFormObject> formObjects = form.getObjects();
        this.worker.setProgressMax(formObjects.size());
        for (TngFormObject formObject : formObjects) {
            this.worker.addProgressValue(1);
            String path = formObject.getPath();
            String name = formObject.getName();
            Node node = xfaForm.getDatasetsNode();
            XfaForm.Xml2SomDatasets som = new XfaForm.Xml2SomDatasets(node);
            for (Map.Entry<String, Node> entry : som.getName2Node().entrySet()) {
                String key = entry.getKey();
                if (!key.equals(path)) continue;
                Node value = entry.getValue();
                for (int i2 = 0; i2 < value.getAttributes().getLength(); ++i2) {
                    Node item = value.getAttributes().item(i2);
                    if (!name.equals(item.getLocalName())) continue;
                    item.setTextContent(this.getFieldValue(name));
                }
            }
        }
        xfaForm.setChanged(true);
    }

    protected void loadDataAcrofields(AcroFields acroFields) throws Exception {
        Set<String> fields = acroFields.getFields().keySet();
        this.worker.setProgressMax(fields.size());
        for (String field : fields) {
            this.worker.addProgressValue(1);
            String value = this.getFieldValue(field);
            if (TngUtilities.isEmpty(value)) continue;
            acroFields.setField(field, value);
        }
    }

    protected String getFieldValue(String field) {
        return this.formFiller.getDataAccessor().getValue(field);
    }

    protected void closeSafe(PdfStamper pdfStamper) {
        try {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

