/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.math.BigDecimal;
import java.util.List;
import tangram.dm.buffer.TngDmBuffer;
import tangram.dm.buffer.eko.ext.DocdefExt;
import tangram.exception.TngException;
import tangram.forms.TngFormDataAccessorDoch;
import tangram.forms.TngFormFillerSql;
import tangram.library.Nat;
import tangram.library.TngUoPeriod;
import tangram.library.TngUtilities;

public abstract class TngFormFillerDoch
extends TngFormFillerSql<TngFormDataAccessorDoch> {
    protected TngUoPeriod periodFrom;
    protected TngUoPeriod periodTo;
    private static final DocdefExt docdefExtBuffer = new DocdefExt();

    protected void resolvePeriod(String periodFrom, String periodTo) throws Exception {
        this.periodFrom = TngUoPeriod.fromString(periodFrom);
        if (this.periodFrom == null) {
            throw new Exception(Nat.x("Dokument nie je mo\u017en\u00e9 vyplni\u0165, za\u010diatok \u00fa\u010dtovn\u00e9ho obdobia nie je zadan\u00fd spr\u00e1vne"));
        }
        this.periodTo = TngUoPeriod.fromString(periodTo);
        if (this.periodTo == null) {
            throw new Exception(Nat.x("Dokument nie je mo\u017en\u00e9 vyplni\u0165, koniec \u00fa\u010dtovn\u00e9ho obdobia nie je zadan\u00fd spr\u00e1vne"));
        }
    }

    protected void fillByDocDet(String formType) throws Exception {
        List<DocdefExt> docdefExts = TngDmBuffer.loadAll(((TngFormDataAccessorDoch)this.getDataAccessor()).getConnection(), docdefExtBuffer, "WHERE " + TngFormFillerDoch.docdefExtBuffer.def.getFullName() + " IS NOT NULL AND " + TngFormFillerDoch.docdefExtBuffer.sablona.getFullName() + "='" + formType + "'", "ORDER BY " + TngFormFillerDoch.docdefExtBuffer.field.getFullName());
        for (DocdefExt docdefExt : docdefExts) {
            try {
                docdefExt.setDefinitions();
                docdefExt.validateDefinitions();
                if (this.fillByDocDetSkip(docdefExt)) {
                    this.fillByDocDetSkipped(docdefExt);
                    continue;
                }
                this.fillByDocDetSimple(docdefExt);
            }
            catch (TngException e2) {
                this.addJournalError(null, e2.getMessage());
            }
        }
    }

    protected boolean fillByDocDetSkip(DocdefExt docdefExt) {
        return false;
    }

    protected void fillByDocDetSkipped(DocdefExt docdefExt) {
        this.setValueB((String)docdefExt.field.getValue(), null);
    }

    protected void fillByDocDetSimple(DocdefExt docdefExt) throws Exception {
        BigDecimal sum = BigDecimal.ZERO;
        for (DocdefExt.Def def : docdefExt.getDefs()) {
            Object[] datas = ((TngFormDataAccessorDoch)this.getDataAccessor()).getConnection().queryObjects(def.generateQuery());
            if (datas == null || datas.length != 9 || datas[0] == null || datas[0].toString().length() < 1) continue;
            char typ = datas[0].toString().charAt(0);
            boolean sideMd = def.isSideMD();
            if (!def.hasSide()) {
                if (typ != 'M' && typ != 'D') {
                    this.addJournalError(null, Nat.x("V\u00fdraz '%1' defin\u00edcie v\u00fdpo\u010dtu po\u013ea '%2' nem\u00e1 zadan\u00fa stranu (%3 | %4) pre \u00fa\u010det s automatick\u00fdm typom zostatku", def.token, docdefExt.field.getValue(), Character.valueOf('M'), Character.valueOf('D')));
                    continue;
                }
                sideMd = typ == 'M';
            }
            BigDecimal pm = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[1] == null ? null : datas[1].toString()));
            BigDecimal pd = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[2] == null ? null : datas[2].toString()));
            BigDecimal om = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[3] == null ? null : datas[3].toString()));
            BigDecimal od = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[4] == null ? null : datas[4].toString()));
            BigDecimal lm = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[5] == null ? null : datas[5].toString()));
            BigDecimal ld = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[6] == null ? null : datas[6].toString()));
            BigDecimal zm = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[7] == null ? null : datas[7].toString()));
            BigDecimal zd = TngUtilities.numberOrZero(TngUtilities.stringToNumber(datas[8] == null ? null : datas[8].toString()));
            BigDecimal value = BigDecimal.ZERO;
            if (def.isValueR()) {
                value = value.add(sideMd ? om : od);
            } else if (def.isValueP()) {
                value = value.add(sideMd ? pm.subtract(pd) : pd.subtract(pm));
            } else if (def.isValueO()) {
                value = value.add(sideMd ? om.subtract(od) : od.subtract(om));
            } else if (def.isValueL()) {
                value = value.add(sideMd ? lm.subtract(ld) : ld.subtract(lm));
            } else if (def.isValueZ()) {
                value = value.add(sideMd ? zm.subtract(zd) : zd.subtract(zm));
            }
            if (def.isSignMinus()) {
                value = value.negate();
            }
            sum = sum.add(value);
        }
        this.setValueB((String)docdefExt.field.getValue(), sum.signum() == 0 ? null : TngUtilities.numberToString(sum));
    }
}

