/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.XfaForm;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tangram.exception.TngException;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormObjectCheckBox;
import tangram.forms.struct.TngFormObjectComboBox;
import tangram.forms.struct.TngFormObjectField;
import tangram.forms.struct.TngFormObjectFieldType;
import tangram.forms.struct.TngFormObjectRadioButton;
import tangram.forms.struct.TngFormPage;
import tangram.forms.struct.TngFormScript;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngFormPdfConverter {
    private final TngForm form = new TngForm();
    private File file;
    private PdfReader pdfReader;
    private Map<String, Integer> scriptsOrders = new HashMap<String, Integer>();
    private Set<String> fieldNames = new HashSet<String>();
    int COLOR = 64;

    public static TngForm convert(File file, String name, String description) throws Exception {
        TngFormPdfConverter converter = new TngFormPdfConverter();
        converter.file = file;
        converter.form.setName(name);
        converter.form.setDescription(description);
        converter.convert();
        return converter.form;
    }

    private void convert() throws Exception {
        try {
            this.pdfReader = new PdfReader(this.file.getAbsolutePath());
            this.loadScriptsOrder();
            for (int pageIndex = 0; pageIndex < this.pdfReader.getNumberOfPages(); ++pageIndex) {
                this.convertPage(pageIndex);
            }
            this.normalizeScriptsOrders();
        }
        finally {
            if (this.pdfReader != null) {
                this.pdfReader.close();
            }
        }
    }

    private void convertPage(int pageIndex) throws Exception {
        TngFormPage formPage = new TngFormPage();
        formPage.setPageIndex(pageIndex);
        Rectangle pageSizeWithRotation = this.pdfReader.getPageSizeWithRotation(pageIndex + 1);
        formPage.setWidth(pageSizeWithRotation.getWidth());
        formPage.setHeight(pageSizeWithRotation.getHeight());
        this.structFromAcrofield(formPage);
        formPage.orderObjects();
        this.form.addPage(formPage);
    }

    private void loadScriptsOrder() throws Exception {
        PRAcroForm acroForm = this.pdfReader.getAcroForm();
        PdfArray array = acroForm.getAsArray(PdfName.CO);
        if (array == null) {
            return;
        }
        int pc = 1;
        for (int i2 = 0; i2 < array.size(); ++i2) {
            PdfString pdfName;
            PdfDictionary dict = array.getAsDict(i2);
            if (dict == null || (pdfName = dict.getAsString(PdfName.T)) == null) continue;
            String name = pdfName.toString();
            if (name != null) {
                this.scriptsOrders.put(name, pc++);
            }
            this.form.getScripts().add(new TngFormScript());
        }
    }

    private void normalizeScriptsOrders() throws Exception {
        ArrayList<TngFormScript> scripts = new ArrayList<TngFormScript>();
        for (TngFormScript script : this.form.getScripts()) {
            if (TngUtilities.isEmpty(script.getExpression())) continue;
            scripts.add(script);
        }
        this.form.getScripts().clear();
        this.form.getScripts().addAll(scripts);
    }

    private void structFromXfa(TngFormPage formPage, XfaForm xfaForm) throws Exception {
        throw new TngException(Nat.x("Na\u010d\u00edtanie \u0161trukt\u00fary formul\u00e1ra z PDF-XFA nie je implementovan\u00e9"));
    }

    private void structFromAcrofield(TngFormPage formPage) throws Exception {
        AcroFields acroFields = this.pdfReader.getAcroFields();
        Map<String, AcroFields.Item> fields = acroFields.getFields();
        for (Map.Entry<String, AcroFields.Item> field : fields.entrySet()) {
            String name = field.getKey();
            AcroFields.Item item = field.getValue();
            int type = acroFields.getFieldType(name);
            for (int size = 0; size < item.size(); ++size) {
                int page = item.getPage(size) - 1;
                if (page != formPage.getPageIndex()) continue;
                PdfDictionary widget = item.getMerged(size);
                TngFormObject formObject = null;
                switch (type) {
                    default: {
                        formObject = this.noneFromAcroField(acroFields, name);
                        break;
                    }
                    case 1: {
                        formObject = this.pushButtonFromAcroField(acroFields, name);
                        break;
                    }
                    case 2: {
                        formObject = this.checkBoxFromAcroField(widget);
                        break;
                    }
                    case 3: {
                        formObject = this.radioButtonFromAcroField(acroFields, name, size);
                        break;
                    }
                    case 4: {
                        formObject = this.textFromAcroField(widget, name);
                        break;
                    }
                    case 5: {
                        formObject = this.listFromAcroField(acroFields, name);
                        break;
                    }
                    case 6: {
                        formObject = this.comboBoxFromAcroField(acroFields, name);
                        break;
                    }
                    case 7: {
                        formObject = this.signatureFromAcroField(acroFields, name);
                    }
                }
                if (formObject == null || this.fieldNames.contains(name)) continue;
                this.fieldNames.add(name);
                formObject.setName(name);
                formObject.setDescription(name);
                formObject.setTabOrder(item.getTabOrder(size));
                PdfArray pdfArrayRect = widget.getAsArray(PdfName.RECT);
                Rectangle itemRec = PdfReader.getNormalizedRectangle(pdfArrayRect);
                formObject.setX(itemRec.getLeft());
                formObject.setY(formPage.getHeight() - itemRec.getTop());
                formObject.setWidth(itemRec.getWidth());
                formObject.setHeight(itemRec.getHeight());
                formPage.addObject(formObject);
            }
        }
    }

    private float[] normalizePositionsTopLeft(BufferedImage image, double pageImageRatio, TngFormObject formObject) {
        int b2;
        int g2;
        int r2;
        int a2;
        int rgb;
        double[] topLeft = new double[]{(double)formObject.getX() * pageImageRatio, (double)formObject.getY() * pageImageRatio};
        for (double x2 = topLeft[0]; x2 > 0.0; x2 -= 1.0) {
            rgb = image.getRGB((int)x2, (int)topLeft[1]);
            a2 = rgb >> 24 & 0xFF;
            r2 = rgb >> 16 & 0xFF;
            g2 = rgb >> 8 & 0xFF;
            b2 = rgb & 0xFF;
            if (r2 >= this.COLOR && g2 >= this.COLOR && b2 >= this.COLOR) continue;
            topLeft[0] = x2;
            break;
        }
        for (double y = topLeft[1]; y > 0.0; y -= 1.0) {
            rgb = image.getRGB((int)topLeft[0], (int)y);
            a2 = rgb >> 24 & 0xFF;
            r2 = rgb >> 16 & 0xFF;
            g2 = rgb >> 8 & 0xFF;
            b2 = rgb & 0xFF;
            if (r2 >= this.COLOR && g2 >= this.COLOR && b2 >= this.COLOR) continue;
            topLeft[1] = y;
            break;
        }
        return new float[]{(float)(topLeft[0] / pageImageRatio), (float)(topLeft[1] / pageImageRatio)};
    }

    private float[] normalizePositionsBottomRight(BufferedImage image, double pageImageRatio, TngFormObject formObject) {
        int b2;
        int g2;
        int r2;
        int a2;
        int rgb;
        double[] bottomRight = new double[]{(double)(formObject.getX() + formObject.getWidth()) * pageImageRatio, (double)(formObject.getY() + formObject.getHeight()) * pageImageRatio};
        for (double x2 = bottomRight[0]; x2 < (double)image.getWidth(); x2 += 1.0) {
            rgb = image.getRGB((int)x2, (int)bottomRight[1]);
            a2 = rgb >> 24 & 0xFF;
            r2 = rgb >> 16 & 0xFF;
            g2 = rgb >> 8 & 0xFF;
            b2 = rgb & 0xFF;
            if (r2 >= this.COLOR && g2 >= this.COLOR && b2 >= this.COLOR) continue;
            bottomRight[0] = x2;
            break;
        }
        for (double y = bottomRight[1]; y < (double)image.getHeight(); y += 1.0) {
            rgb = image.getRGB((int)bottomRight[0], (int)y);
            a2 = rgb >> 24 & 0xFF;
            r2 = rgb >> 16 & 0xFF;
            g2 = rgb >> 8 & 0xFF;
            b2 = rgb & 0xFF;
            if (r2 >= this.COLOR && g2 >= this.COLOR && b2 >= this.COLOR) continue;
            bottomRight[1] = y;
            break;
        }
        return new float[]{(float)(bottomRight[0] / pageImageRatio), (float)(bottomRight[1] / pageImageRatio)};
    }

    private TngFormObject noneFromAcroField(AcroFields acroFields, String name) {
        System.err.println("noneFromAcroField not implemented for " + name);
        return null;
    }

    private TngFormObject pushButtonFromAcroField(AcroFields acroFields, String name) {
        System.err.println("pushButtonFromAcroField not implemented for " + name);
        return null;
    }

    private TngFormObject checkBoxFromAcroField(PdfDictionary widget) {
        TngFormObjectCheckBox formObject = new TngFormObjectCheckBox();
        return formObject;
    }

    private TngFormObject radioButtonFromAcroField(AcroFields acroFields, String name, int merge) {
        TngFormObjectRadioButton formObject = new TngFormObjectRadioButton();
        String[] optionsExport = acroFields.getListOptionExport(name);
        if (optionsExport != null && optionsExport.length > merge) {
            formObject.setTrueValue(optionsExport[merge]);
        }
        return formObject;
    }

    private TngFormObject textFromAcroField(PdfDictionary widget, String name) throws Exception {
        PdfDictionary widgetAa;
        int ffInt;
        PdfNumber ff;
        TngFormObjectField formObject = new TngFormObjectField();
        formObject.setType(TngFormObjectFieldType.STRING);
        PdfNumber maxLen = widget.getAsNumber(PdfName.MAXLEN);
        if (maxLen != null) {
            formObject.setPrecision(maxLen.intValue());
        }
        if ((ff = widget.getAsNumber(PdfName.FF)) != null && ((ffInt = ff.intValue()) & 0x1000) != 0) {
            formObject.setType(TngFormObjectFieldType.AREA);
        }
        if ((widgetAa = widget.getAsDict(PdfName.AA)) != null) {
            PdfDictionary widgetAaF;
            PdfObject widgetAaFJS;
            String format;
            PdfDictionary widgetAaC = widgetAa.getAsDict(PdfName.C);
            if (widgetAaC != null) {
                Integer pc;
                PdfStream widgetAaCJS = widgetAaC.getAsStream(PdfName.JS);
                PRStream stream = (PRStream)widgetAaCJS;
                String streamStr = new String(PdfReader.getStreamBytes(stream));
                String expression = "{" + name + "}=";
                int expIndexFrom = streamStr.indexOf("/** BVCALC");
                int expIndexTo = streamStr.lastIndexOf("EVCALC **/");
                if (expIndexFrom != -1 && expIndexTo != -1) {
                    expression = expression + "{" + streamStr.substring("/** BVCALC".length(), expIndexTo - 1).trim() + "}";
                    expression = expression.replace("+", "}+{");
                    expression = expression.replace("-", "}-{");
                    expression = expression.replace("*", "}*{");
                    expression = expression.replace("/", "}/{");
                    expression = expression.replace("==0?0:", "}==0?0:{");
                }
                if ((pc = this.scriptsOrders.get(name)) != null && pc > 0) {
                    TngFormScript formScript = this.form.getScripts().get(pc - 1);
                    formScript.setExpression(expression);
                }
            }
            if ((format = (widgetAaFJS = (widgetAaF = widgetAa.getAsDict(PdfName.F)).get(PdfName.JS)).toString()).startsWith("AFDate_") || format.startsWith("AFTime_")) {
                formObject.setType(TngFormObjectFieldType.DATE);
            } else {
                int scale;
                int formatIndexFrom = format.indexOf("AFNumber_Format(");
                if (formatIndexFrom != -1) {
                    scale = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(format, "AFNumber_Format(".length(), 1), 0);
                    formObject.setScale(scale == 0 ? null : Integer.valueOf(scale));
                    formObject.setType(scale == 0 ? TngFormObjectFieldType.INTEGER : TngFormObjectFieldType.DECIMAL);
                }
                if ((formatIndexFrom = format.indexOf("AFPercent_Format(")) != -1) {
                    scale = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(format, "AFPercent_Format(".length(), 1), 0);
                    formObject.setScale(scale == 0 ? null : Integer.valueOf(scale));
                    formObject.setType(scale == 0 ? TngFormObjectFieldType.INTEGER : TngFormObjectFieldType.DECIMAL);
                }
            }
            PdfDictionary widgetAaK = widgetAa.getAsDict(PdfName.K);
            PdfObject widgetAaKJS = widgetAaK.get(PdfName.JS);
            String string = widgetAaKJS.toString();
        }
        return formObject;
    }

    private TngFormObject listFromAcroField(AcroFields acroFields, String name) {
        System.err.println("listFromAcroField not implemented for " + name);
        return null;
    }

    private TngFormObject comboBoxFromAcroField(AcroFields acroFields, String name) {
        TngFormObjectComboBox formObject = new TngFormObjectComboBox();
        String[] optionsDisplay = acroFields.getListOptionDisplay(name);
        String[] optionsExport = acroFields.getListOptionExport(name);
        ArrayList<TngFormObjectComboBox.Option> options = new ArrayList<TngFormObjectComboBox.Option>();
        if (optionsDisplay != null && optionsExport != null) {
            for (int i2 = 0; i2 < optionsDisplay.length; ++i2) {
                TngFormObjectComboBox.Option option = new TngFormObjectComboBox.Option();
                option.setDisplay(optionsDisplay[i2]);
                option.setExport(optionsExport[i2]);
                options.add(option);
            }
        }
        formObject.setOptions(options);
        return formObject;
    }

    private TngFormObject signatureFromAcroField(AcroFields acroFields, String name) {
        System.err.println("signatureFromAcroField not implemented for " + name);
        return null;
    }
}

