/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngField;
import tangram.swing.panel.TngPanel;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueEvent;

public class TngFormScriptWizard
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngFormScript formScript;
    private List<TngFormComponent> formComponents;

    public TngFormScriptWizard() {
        try {
            this.jbInit();
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(426, 23));
        TngSwing.setOptimalHeight(this);
    }

    @Override
    public String getCustomText() {
        return Nat.x("Zobrazi\u0165 v\u00fdpo\u010det");
    }

    @Override
    public boolean doCustom() {
        if (this.formScript != null) {
            TngSwing.msgOK(this.formScript.getExpression());
        }
        return false;
    }

    public void setData(TngFormScript formScript, List<TngFormComponent> formComponents) {
        this.formScript = formScript;
        this.formComponents = formComponents;
        this.addComponents();
        TngSwing.setOptimalHeight(this);
    }

    private void addComponents() {
        this.removeAll();
        for (int i2 = 0; i2 < this.formComponents.size(); ++i2) {
            TngFormComponent formComponent = this.formComponents.get(i2);
            JComponent component = formComponent.getComponent();
            TngFormObject formObject = formComponent.getFormObject();
            boolean isVirtual = formObject.isVirtual();
            if (component instanceof TngField) {
                ((TngField)component).addValueListener(new TngValueAdapter(){

                    @Override
                    public void valueChangedUser(TngValueEvent e2) {
                        TngFormScriptWizard.this.recalc();
                    }
                });
                if (i2 == this.formComponents.size() - 1) {
                    ((TngField)component).changeFontRelative(1, 1.0f);
                }
            }
            TngLabel label = new TngLabel();
            label.setText(formObject.getDescription());
            label.setToolTipText(formObject.getName());
            component.setEnabled(isVirtual);
            if (i2 == this.formComponents.size() - 1) {
                label.changeFontRelative(1, 1.0f);
            }
            this.add((Component)label, new GridBagConstraints(0, i2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.add((Component)formComponent.getComponent(), new GridBagConstraints(1, i2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 70, 10));
        }
        this.recalc();
    }

    private void recalc() {
        if (this.formScript != null) {
            this.formScript.getOperator().executeScript(this.formComponents);
        }
    }
}

