/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tangram.exception.TngException;
import tangram.library.Nat;

public class TngFormZipFile {
    private static final String ZIP_FILENAME = "forms.zip";
    private ZipFile zipFile;

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    private ZipFile getZipFileInner() throws Exception {
        if (this.getZipFile() == null) {
            throw new TngException(Nat.x("S\u00fabor '%1' nebol otvoren\u00fd na \u010d\u00edtanie", ZIP_FILENAME));
        }
        return this.getZipFile();
    }

    public void open() throws Exception {
        File zipFile = new File(ZIP_FILENAME);
        if (!zipFile.exists() || !zipFile.isFile()) {
            throw new TngException(Nat.x("S\u00fabor '%1' nebol n\u00e1jden\u00fd", zipFile.getAbsolutePath()));
        }
        this.setZipFile(new ZipFile(zipFile));
    }

    public long getLastModified(String zipEntryName) throws Exception {
        ZipEntry zipEntry = this.getZipFileInner().getEntry(zipEntryName);
        if (zipEntry == null) {
            throw new TngException(Nat.x("S\u00fabor '%1' neobsahuje s\u00fabor '%2'", this.getZipFile().getName(), zipEntryName));
        }
        return zipEntry.getTime();
    }

    public InputStream getZippedInputStream(String zipEntryName) throws Exception {
        ZipEntry zipEntry = this.getZipFileInner().getEntry(zipEntryName);
        if (zipEntry == null) {
            throw new TngException(Nat.x("S\u00fabor '%1' neobsahuje s\u00fabor '%2'", this.getZipFile().getName(), zipEntryName));
        }
        return this.getZipFileInner().getInputStream(zipEntry);
    }

    public void close() {
        if (this.getZipFile() == null) {
            return;
        }
        try {
            this.getZipFile().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

