/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.script;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import tangram.forms.TngFormGroup;
import tangram.forms.script.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.components.TngFormCheckBox;
import tangram.forms.visual.components.TngFormComboBox;
import tangram.library.TngUtilities;

public class TngFormScriptEnabledIf
extends TngFormScript<TngFormComponent> {
    public static final String NAME = "EnabledIf";
    private String[] params;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute() {
        this.params = TngUtilities.strTokenizeNotNull(this.param, ',');
        if (this.params.length < 2) {
            return;
        }
        TngFormGroup group = this.form.getGroup(this.params[0]);
        if (group != null) {
            this.executeGroup(group);
        } else {
            TngFormComponent target1 = this.getFormComponentByName(this.params[0]);
            if (target1 instanceof TngFormComboBox) {
                this.executeComboBox((TngFormComboBox)target1);
            } else if (target1 instanceof TngFormCheckBox) {
                this.executeCheckBox((TngFormCheckBox)target1);
            }
        }
    }

    private void executeGroup(TngFormGroup group) {
        ButtonGroup buttonGroup = group.getButtonGroup();
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    if (e2.getStateChange() != 1) {
                        return;
                    }
                    TngFormScriptEnabledIf.this.enableIf(TngFormScriptEnabledIf.this.form.getGroupValue(TngFormScriptEnabledIf.this.params[0]));
                }
            });
        }
        this.enableIf(this.form.getGroupValue(this.params[0]));
    }

    private void executeComboBox(final TngFormComboBox target) {
        target.getComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() != 1) {
                    return;
                }
                TngFormScriptEnabledIf.this.enableIf(target.getValue());
            }
        });
        this.enableIf(target.getValue());
    }

    private void executeCheckBox(final TngFormCheckBox target) {
        target.getComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngFormScriptEnabledIf.this.enableIf(target.getValue());
            }
        });
        this.enableIf(target.getValue());
    }

    private void enableIf(String enableIfValue) {
        boolean enabled = false;
        for (int i2 = 1; i2 < this.params.length && !enabled; ++i2) {
            if (this.params[i2] == null || !this.params[i2].equalsIgnoreCase(enableIfValue)) continue;
            enabled = true;
        }
        this.source.getComponent().setEnabled(enabled);
    }
}

