/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import tangram.exception.TngException;
import tangram.exception.TngExceptionAbort;
import tangram.forms.TngForms;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormObjectField;
import tangram.forms.struct.TngFormObjectLink;
import tangram.forms.struct.TngFormPage;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.TngFormPanelFocusTraversalPolicy;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngPicture;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngProgressableWorker;

public class TngFormPanel
extends TngPanel {
    private TngForm form;
    private TngFormPage formPage;
    private float realZoom;
    private float minZoom = 1.0f;
    private float maxZoom = 2.0f;
    private boolean fitPage;
    private boolean fitWidth;
    private int workPlaceX;
    private int workPlaceImageX;
    private int workPlaceWidth;
    private int workPlaceHeight;
    private BufferedImage workPlaceImage;
    private BufferedImage workPlaceImageActual;
    private List<TngFormComponent> formComponents = new ArrayList<TngFormComponent>();
    private TngFormPanelFocusTraversalPolicy focusTraversalPolicy = new TngFormPanelFocusTraversalPolicy();
    private static final Border FIELD_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(0, 3, 0, 3));
    int actualPageIndex = -1;

    public TngFormPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setBackground(Color.GRAY);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(this.focusTraversalPolicy);
    }

    public List<TngFormComponent> getFormComponents() {
        return this.formComponents;
    }

    public void loadForm(TngForm form, TngProgressableWorker worker) throws TngException {
        this.form = form;
        this.prepareForm();
        this.clear();
        this.addFormObjects(worker);
        this.setScripts();
        this.loadPage(0);
        this.calcZoomRatios();
    }

    public void clear() {
        for (TngFormComponent formComponent : this.formComponents) {
            formComponent.setFormObject(null);
        }
        this.formComponents.clear();
        this.removeAll();
    }

    private void addFormObjects(TngProgressableWorker worker) throws TngException {
        if (this.isNull(this.form.getObjects())) {
            return;
        }
        worker.setProgressMax(this.form.getObjects().size());
        for (TngFormObject formObject : this.form.getObjects()) {
            if (worker.isProgressCanceled()) {
                throw new TngExceptionAbort();
            }
            worker.addProgressValue(1);
            this.addFormObject(formObject);
        }
    }

    private void addFormObject(TngFormObject formObject) {
        boolean isFieldTransparent = Boolean.valueOf(this.form.getProperties().get("transparentField"));
        boolean isFieldHighlight = Boolean.valueOf(this.form.getProperties().get("highlightField"));
        TngFormComponent formComponent = TngFormComponent.createFromFormObject(this.form, formObject);
        this.formComponents.add(formComponent);
        if (!formObject.isVirtual()) {
            if (this.drawFieldBorder(formObject)) {
                formComponent.getComponent().setBorder(FIELD_BORDER);
            }
            formComponent.setTransparent(isFieldTransparent);
            formComponent.setHighlight(isFieldHighlight);
            this.add((Component)formComponent.getComponent(), 0);
        }
    }

    private boolean drawFieldBorder(TngFormObject formObject) {
        boolean isDrawFieldBorder = Boolean.valueOf(this.form.getProperties().get("drawFieldBorder"));
        return isDrawFieldBorder && (formObject instanceof TngFormObjectField || formObject instanceof TngFormObjectLink);
    }

    private void setScripts() {
        for (TngFormComponent formComponent : this.formComponents) {
            formComponent.script(this.formComponents);
            if (formComponent.getFormObject().isScriptLeft()) {
                formComponent.scriptLeft(this.formComponents);
            }
            if (!formComponent.getFormObject().isScriptRight()) continue;
            formComponent.scriptRight(this.formComponents);
        }
    }

    public void loadPage(int pageIndex) {
        this.disposeImages();
        this.actualPageIndex = pageIndex;
        this.formPage = this.form.getPage(pageIndex);
        this.workPlaceImage = this.loadImage(this.formPage.getPageIndex() + 1);
        for (TngFormComponent formComponent : this.formComponents) {
            formComponent.getComponent().setVisible(this.formPage.getObjects().contains(formComponent.getFormObject()));
        }
        this.setFocusTraversalPolicy();
        this.repaint();
    }

    private void setFocusTraversalPolicy() {
        this.focusTraversalPolicy.setData(this.formComponents);
        Component firstComponent = this.focusTraversalPolicy.getFirstComponent(this);
        if (firstComponent != null) {
            firstComponent.requestFocusInWindow();
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintBackground(g2);
        this.paintWorkPlaceImage(g2);
        this.paintFormComponents(g2);
        this.paintCustom(g2);
    }

    private void paintBackground(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.isBackgroundSet() && this.isOpaque()) {
            g22.setBackground(this.getBackground());
            g22.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void paintWorkPlaceImage(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.workPlaceImageActual != null) {
            g22.drawImage((Image)this.workPlaceImageActual, this.workPlaceImageX, 0, null);
        }
    }

    private void paintFormComponents(Graphics g2) {
        for (TngFormComponent formComponent : this.formComponents) {
            if (!formComponent.getComponent().isVisible()) continue;
            formComponent.translate(this.workPlaceX, 0, this.realZoom);
        }
    }

    protected void paintCustom(Graphics g2) {
    }

    public int getPageIndex() {
        return this.actualPageIndex;
    }

    public boolean hasPages() {
        return this.form != null && this.form.getPages() != null && this.form.getPages().size() > 0;
    }

    public int getPageCount() {
        return !this.hasPages() ? 0 : this.form.getPages().size();
    }

    public void refreshPage() {
        this.actualizeWorkPlace();
        Dimension dim = new Dimension(0, this.workPlaceHeight);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.revalidate();
        this.repaint();
    }

    public void disposeImages() {
        if (this.workPlaceImage != null) {
            this.workPlaceImage.getGraphics().dispose();
        }
        if (this.workPlaceImageActual != null) {
            this.workPlaceImageActual.getGraphics().dispose();
        }
        this.workPlaceImage = null;
        this.workPlaceImageActual = null;
        this.revalidate();
        this.repaint();
    }

    private void actualizeWorkPlace() {
        int fullWidth = this.getWidth();
        this.workPlaceWidth = (int)(this.getFormWidth() * this.realZoom);
        this.workPlaceHeight = (int)(this.getFormHeight() * this.realZoom);
        this.workPlaceX = (fullWidth - this.workPlaceWidth) / 2;
        if (this.workPlaceImage == null) {
            this.workPlaceImageActual = null;
            return;
        }
        if (this.workPlaceImageActual == null || this.workPlaceImageActual.getWidth() != this.workPlaceWidth || this.workPlaceImageActual.getHeight() != this.workPlaceHeight) {
            this.workPlaceImageActual = TngPicture.resize(this.workPlaceImage, this.workPlaceWidth, this.workPlaceHeight, true, false);
            this.workPlaceImageX = (fullWidth - this.workPlaceImageActual.getWidth()) / 2;
        }
    }

    private float getFormWidth() {
        return this.formPage == null ? -1.0f : this.formPage.getWidth();
    }

    private float getFormHeight() {
        return this.formPage == null ? -1.0f : this.formPage.getHeight();
    }

    private boolean isNull(Object object) {
        return object == null;
    }

    public void componentResized() {
        this.calcZoomRatios();
    }

    public void setZoomRatio(float newZoom) {
        this.fitPage = false;
        this.fitWidth = false;
        this.setRealZoomRatio(newZoom);
    }

    public void addZoomRatio(float addZoom) {
        this.setZoomRatio(this.realZoom + addZoom);
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom < this.minZoom) {
            newZoom = this.minZoom;
        }
        if (newZoom > this.maxZoom) {
            newZoom = this.maxZoom;
        }
        if (this.realZoom > newZoom) {
            this.realZoom = newZoom;
        } else if (this.realZoom < newZoom) {
            int workPlaceWidth = (int)(this.getFormWidth() * this.realZoom);
            int workPlaceHeight = (int)(this.getFormHeight() * this.realZoom);
            if (this.workPlaceImage != null && this.workPlaceImage.getWidth() > workPlaceWidth && this.workPlaceImage.getHeight() > workPlaceHeight) {
                this.realZoom = newZoom;
            }
        }
    }

    private BufferedImage loadImage(int pageIndex) {
        try {
            return TngForms.loadPage(this.form.getName(), pageIndex);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
            return null;
        }
    }

    public void calcZoomRatios() {
        this.minZoom = 1.5f;
        this.maxZoom = this.workPlaceImage == null ? 2.0f : (float)this.workPlaceImage.getWidth() / this.getFormWidth();
        this.setZoomRatio((this.minZoom + this.maxZoom) / 2.3f);
    }

    private void prepareForm() {
        ArrayList<TngFormPage> formPages = new ArrayList<TngFormPage>();
        for (TngFormPage formPage : this.form.getPages()) {
            if (!formPage.getProperties().containsKey("repeat")) {
                formPages.add(formPage);
                continue;
            }
            int repeatMin = TngUtilities.strToInt(formPage.getProperties().get("repeatMin"), 1);
            int repeatMax = TngUtilities.strToInt(formPage.getProperties().get("repeatMax"), 1);
            int repeatStep = TngUtilities.strToInt(formPage.getProperties().get("repeatStep"), 1);
            formPage.getProperties().remove("repeat");
            formPage.getProperties().remove("repeatMin");
            formPage.getProperties().remove("repeatMax");
            formPage.getProperties().remove("repeatStep");
            try {
                for (int repeat = repeatMin; repeat <= repeatMax; repeat += repeatStep) {
                    TngFormPage newPage = (TngFormPage)formPage.clone();
                    for (TngFormObject formObject : newPage.getObjects()) {
                        if (!TngUtilities.isEmpty(formObject.getPath())) {
                            formObject.setPath(formObject.getPath().replace("{repeat}", String.valueOf(repeat)));
                        }
                        if (TngUtilities.isEmpty(formObject.getName())) continue;
                        formObject.setName(formObject.getName().replace("{repeat}", String.valueOf(repeat)));
                    }
                    formPages.add(newPage);
                }
                formPages.remove(formPage);
            }
            catch (CloneNotSupportedException e2) {
                e2.printStackTrace();
            }
        }
        this.form.setPages(formPages);
        this.form.initialize();
    }
}

