/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import tangram.forms.struct.TngFormObjectComboBox;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.library.TngUtilities;
import tangram.swing.component.TngComboBox;

public class TngFormComboBox
extends TngFormComponent {
    protected TngComboBox component;

    @Override
    protected void initialize() {
        this.component = new TngComboBox();
        this.getComponent().setRenderer(new ComboBoxRenderer());
        this.getComponent().addItem(new TngFormObjectComboBox.Option());
        List<TngFormObjectComboBox.Option> options = this.getFormObject().getOptions();
        if (options != null) {
            for (TngFormObjectComboBox.Option option : options) {
                this.getComponent().addItem(option);
            }
        }
        super.initialize();
    }

    @Override
    public TngComboBox getComponent() {
        return this.component;
    }

    @Override
    public TngFormObjectComboBox getFormObject() {
        return (TngFormObjectComboBox)super.getFormObject();
    }

    @Override
    public void scriptRight(final List<TngFormComponent> formComponents) {
        super.scriptRight(formComponents);
        this.getComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (TngFormScript formScript : TngFormComboBox.this.getForm().getScripts()) {
                    formScript.getOperator().executeScript(formComponents);
                }
            }
        });
    }

    @Override
    public void setValue(String value) {
        if (TngUtilities.isEmpty(value)) {
            return;
        }
        for (int i2 = 0; i2 < this.getComponent().getItemCount(); ++i2) {
            Object item = this.getComponent().getItemAt(i2);
            if (!(item instanceof TngFormObjectComboBox.Option) || !value.equals(((TngFormObjectComboBox.Option)item).getExport())) continue;
            this.getComponent().setSelectedIndex(i2);
        }
    }

    @Override
    public String getValue() {
        Object val = this.getComponent().getSelectedItem();
        return val instanceof TngFormObjectComboBox.Option ? ((TngFormObjectComboBox.Option)val).getExport() : null;
    }

    private static class ComboBoxRenderer
    extends BasicComboBoxRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object obj, int row, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, obj, row, isSelected, hasFocus);
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(list.getForeground());
            }
            if (obj instanceof TngFormObjectComboBox.Option) {
                TngFormObjectComboBox.Option option = (TngFormObjectComboBox.Option)obj;
                this.setText(option.getDisplay());
            } else {
                this.setText(obj == null ? null : obj.toString());
            }
            return this;
        }
    }
}

