/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual.components;

import java.awt.Dimension;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import tangram.forms.visual.components.TngFormField;
import tangram.library.TngUtilities;
import tangram.swing.component.field.TngFieldDecimal;

public class TngFormFieldDecimal
extends TngFormField {
    @Override
    protected void initialize() {
        this.field = new TngFieldDecimal();
        this.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.getComponent().setHorizontalAlignment(4);
        if (this.getFormObject().getPrecision() != null) {
            Dimension valueSize = new Dimension(this.getFormObject().getPrecision(), this.getFormObject().getScale() == null ? 0 : this.getFormObject().getScale());
            this.getComponent().setValueSize(valueSize);
        }
        super.initialize();
    }

    @Override
    public TngFieldDecimal getComponent() {
        return (TngFieldDecimal)this.field;
    }

    @Override
    public void setValue(String value) {
        this.getComponent().setDecimal(TngUtilities.stringToNumber(value));
    }

    @Override
    public String getValue() {
        return TngUtilities.numberToString(this.getComponent().getDecimalDef(null));
    }

    @Override
    public String afterScriptNormalizeValue(String value) {
        if (TngUtilities.isEmpty(value)) {
            return value;
        }
        Dimension valueSize = this.getComponent().getValueSize();
        BigDecimal valueDec = TngUtilities.stringToNumber(value);
        if (valueDec != null) {
            return TngUtilities.numberToString(valueDec, valueSize.height);
        }
        return value;
    }
}

