/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual.components;

import java.math.BigDecimal;
import javax.swing.BorderFactory;
import tangram.forms.visual.components.TngFormField;
import tangram.library.TngUtilities;
import tangram.swing.component.field.TngFieldInteger;

public class TngFormFieldInteger
extends TngFormField {
    @Override
    protected void initialize() {
        this.field = new TngFieldInteger();
        this.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.getComponent().setHorizontalAlignment(4);
        if (this.getFormObject().getPrecision() != null) {
            this.getComponent().setValueSize(this.getFormObject().getPrecision());
        }
        super.initialize();
    }

    @Override
    public TngFieldInteger getComponent() {
        return (TngFieldInteger)this.field;
    }

    @Override
    public void setValue(String value) {
        Integer val = TngUtilities.strToInt(value, Integer.MAX_VALUE);
        this.getComponent().setInteger(val == null || val == Integer.MAX_VALUE ? null : val);
    }

    @Override
    public String getValue() {
        Integer val = this.getComponent().getIntegerDef(null);
        return val == null ? null : String.valueOf(val);
    }

    @Override
    public String afterScriptNormalizeValue(String value) {
        if (TngUtilities.isEmpty(value)) {
            return value;
        }
        BigDecimal valueDec = TngUtilities.stringToNumber(value);
        return valueDec == null ? null : String.valueOf(valueDec.intValue());
    }
}

