/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngDataLink {
    private Socket client;
    protected InputStreamReader inputStream;
    protected OutputStreamWriter outputStream;
    private StringBuilder readBuffer = new StringBuilder(10);
    private static final char PACKET_END = '\r';

    public synchronized void open() throws Exception {
        this.close();
        ServerSocket socketServer = null;
        try {
            socketServer = new ServerSocket(2602, 10, InetAddress.getByName(null));
            socketServer.setSoTimeout(6000);
            this.client = socketServer.accept();
            this.inputStream = new InputStreamReader(this.client.getInputStream(), "windows-1250");
            this.outputStream = new OutputStreamWriter(this.client.getOutputStream(), "windows-1250");
            this.sendData("STATUS", Nat.x("Pripojenie \u00faspe\u0161n\u00e9"));
            this.closeSocket(socketServer);
        }
        catch (Throwable throwable) {
            this.closeSocket(socketServer);
            throw throwable;
        }
    }

    private void closeSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
            }
        }
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
            }
            this.client = null;
        }
        this.inputStream = null;
        this.outputStream = null;
    }

    private void readData() throws Exception {
        this.readBuffer.setLength(0);
        while (true) {
            int c2;
            if ((c2 = this.inputStream.read()) < 0) {
                throw new Exception(Nat.nox("Socket zatvoren\u00fd"));
            }
            if (c2 == 13) break;
            this.readBuffer.append((char)c2);
        }
    }

    public synchronized void sendData(String key, String value) throws Exception {
        try {
            this.outputStream.write(key + "=" + value + '\r');
            this.outputStream.flush();
            this.readData();
            String answer = this.readBuffer.toString();
            if (!answer.equals("OK")) {
                throw new Exception(Nat.nox("Prijat\u00e1 neo\u010dak\u00e1van\u00e1 odpove\u010f %1", answer));
            }
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public synchronized void sendDataSafe(String key, String value) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.sendData(key, value);
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public void sendExitValue(int retValue) {
        this.sendDataSafe("RETURN", Integer.toString(retValue));
    }

    public void sendExitError(String text) {
        text = text.replace('\r', '\n');
        this.sendDataSafe("ERROR", text);
    }

    public void sendStatus(String line) {
        this.sendDataSafe("STATUS", line);
    }
}

