/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.library.TngFtpType;
import tangram.library.TngParams;
import tangram.library.TngUtilities;

public class TngFtp {
    private String server;
    private int port = 21;
    private String username;
    private String password;
    private boolean passive;
    private TngFtpType type = TngFtpType.FTP_CONNECTION;
    private FTPClient client;

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setType(TngFtpType type) {
        this.type = type;
    }

    public TngFtpType getType() {
        return this.type;
    }

    public FTPClient openClient() throws Exception {
        FTPClient client = null;
        TngFtpType type = this.getType();
        client = !type.isSecured() ? new FTPClient() : new FTPSClient(type.getProtocol(), type.isImplicit());
        client.setDataTimeout(10000);
        client.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
        client.connect(this.getServer(), this.getPort());
        if (!FTPReply.isPositiveCompletion(client.getReplyCode())) {
            throw new TngException(Nat.x("FTP server odmietol pripojenie"));
        }
        if (!client.login(this.getUsername(), this.getPassword())) {
            throw new TngException(Nat.x("Nespr\u00e1vne prihlasovacie \u00fadaje"));
        }
        client.setFileType(2);
        if (this.isPassive()) {
            client.enterLocalPassiveMode();
        } else {
            client.enterLocalActiveMode();
        }
        this.client = client;
        return client;
    }

    public void changeDir(String dir) throws Exception {
        this.client.changeWorkingDirectory(dir);
    }

    public List<FTPFile> listFiles(final String fileMask) throws Exception {
        FTPFile[] ftpFiles = null;
        ftpFiles = this.client.listFiles(null, new FTPFileFilter(){

            @Override
            public boolean accept(FTPFile file) {
                if (file == null || !file.isFile()) {
                    return false;
                }
                if (TngUtilities.isEmpty(fileMask)) {
                    return true;
                }
                String fileName = file.getName();
                String pattern = fileMask.replace(".", "\\.").replace("*", ".*");
                return fileName.matches(pattern);
            }
        });
        return Arrays.asList(ftpFiles);
    }

    public List<File> downloadFiles(List<FTPFile> sourceFiles, String targetPath) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (FTPFile ftpFile : sourceFiles) {
            File targetFile = new File(targetPath, ftpFile.getName());
            this.downloadFile(ftpFile, targetFile);
            files.add(targetFile);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(FTPFile sourcePath, File targetFile) throws Exception {
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(targetFile);
            this.client.retrieveFile(sourcePath.getName(), oStream);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(oStream);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(oStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(File sourceFile, FTPFile targetPath) throws Exception {
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(sourceFile);
            this.client.storeFile(targetPath.getName(), iStream);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(iStream);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(iStream);
    }

    public void deleteFile(FTPFile file) throws Exception {
        this.client.deleteFile(file.getName());
    }

    public void closeConnection() throws Exception {
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
    }

    public void loadFromParams(TngParams params) {
        this.setServer(params.getString("FtpServer"));
        this.setPort(params.getInt("FtpPort", 21));
        this.setUsername(params.getString("FtpUsername"));
        this.setPassword(params.getString("FtpPassword"));
        this.setPassive(params.getBoolean("FtpPassive", false));
        this.setType(TngFtpType.find(params.getString("FtpType")));
    }

    public void saveToParams(TngParams params) {
        params.setString("FtpServer", this.getServer());
        params.setInt("FtpPort", this.getPort());
        params.setString("FtpUsername", this.getUsername());
        params.setString("FtpPassword", this.getPassword());
        params.setBoolean("FtpPassive", this.isPassive());
        params.setString("FtpType", this.getType().getSavedValue());
    }

    public String toString() {
        return this.getServer() + ":" + this.getPort() + " (" + this.getUsername() + "/***), PASSIVE: " + this.isPassive() + ", TYPE:" + this.getType().name();
    }
}

