/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import tangram.library.Nat;
import tangram.library.TngJournalFileListener;
import tangram.library.TngJournalRow;
import tangram.library.TngUtilities;

public class TngJournalFile {
    private static final SimpleDateFormat yyMMddhhmmss = new SimpleDateFormat("yyMMddhhmmss");
    private File journalFile;
    private int level;
    private int errors;
    private int rows;
    private String[] groups = new String[10];
    private TngJournalFileListener journalListener;

    public void setJournalListener(TngJournalFileListener journalListener) {
        this.journalListener = journalListener;
    }

    public void open(String workingDir, boolean deleteOnExit) throws Exception {
        this.close();
        File dirJrn = new File(workingDir == null ? System.getProperty("user.dir") : workingDir);
        if (!dirJrn.exists() && !dirJrn.mkdirs()) {
            throw new Exception(Nat.x("Nie je mo\u017en\u00e9 vytvori\u0165 adres\u00e1r %1", dirJrn.getAbsolutePath()));
        }
        this.journalFile = new File(dirJrn, "tmp_" + TngUtilities.dateTimeToStr(new Date(), yyMMddhhmmss));
        if (deleteOnExit) {
            this.journalFile.deleteOnExit();
        }
        if (this.journalListener != null) {
            this.journalListener.journalOpened();
        }
    }

    public void begin(String title, String group) {
        if (this.level < 0) {
            this.level = 0;
        }
        if (this.level == 0) {
            this.clear();
        }
        if (!TngUtilities.isEmpty(title)) {
            this.add(title, null, group, TngJournalRow.RowType.T);
        }
        if (this.groups.length <= this.level) {
            String[] newDefGroups = new String[this.groups.length + 10];
            System.arraycopy(this.groups, 0, newDefGroups, 0, this.groups.length);
            this.groups = newDefGroups;
        }
        this.groups[this.level] = group;
        ++this.level;
    }

    public void end(String text) {
        --this.level;
        if (this.level < 0) {
            this.level = 0;
        }
        if (!TngUtilities.isEmpty(text)) {
            this.add(text, null, this.groups[this.level], TngJournalRow.RowType.I);
        }
    }

    public void info(String text, String ident, String group) {
        this.add(text, ident, group, TngJournalRow.RowType.I);
    }

    public void error(String text, String ident, String group) {
        this.add(text, ident, group, TngJournalRow.RowType.E);
    }

    public int getRows() {
        return this.rows;
    }

    public int getErrors() {
        return this.errors;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public String getIdent(int row) {
        return null;
    }

    public void setLevel(int level) {
        while (this.level > level) {
            this.end(null);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public TngJournalRow getRow(int row) {
        if (row < 0 || row >= this.rows) {
            return null;
        }
        try {
            String data = this.journalFileRead(row);
            return TngJournalRow.fromString(data);
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
            return null;
        }
    }

    public void close() {
        this.level = 0;
        this.rows = 0;
        this.errors = 0;
        this.groups = new String[10];
        this.journalFile = null;
        if (this.journalListener != null) {
            this.journalListener.journalClosed();
        }
    }

    private void clear() {
        if (this.journalFile != null) {
            this.journalFileClear();
        }
        this.rows = 0;
        this.errors = 0;
        this.groups = new String[10];
        if (this.journalListener != null) {
            this.journalListener.journalCleared();
        }
    }

    private void add(String text, String ident, String group, TngJournalRow.RowType type) {
        TngJournalRow row = new TngJournalRow();
        row.setText(text);
        row.setIdent(ident);
        if (TngUtilities.isEmpty(group) && this.level != 0) {
            group = this.groups[this.level - 1];
        }
        row.setGroup(group);
        row.setType(type);
        row.setLevel(this.level);
        this.addRow(row);
    }

    private void addRow(TngJournalRow row) {
        ++this.rows;
        if (row.isError()) {
            ++this.errors;
        }
        try {
            this.journalFileAppend(row.toString());
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        if (this.journalListener != null) {
            this.journalListener.rowAdded(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String journalFileRead(int row) throws Exception {
        RandomAccessFile rafJournalFile = null;
        try {
            rafJournalFile = new RandomAccessFile(this.journalFile, "r");
            byte[] data = new byte[318];
            rafJournalFile.seek(row * 318);
            rafJournalFile.readFully(data);
            rafJournalFile.close();
            rafJournalFile = null;
            String string = new String(data, "windows-1250");
            this.closeFileSafe(rafJournalFile);
            return string;
        }
        catch (Throwable throwable) {
            this.closeFileSafe(rafJournalFile);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void journalFileAppend(String data) throws Exception {
        RandomAccessFile rafJournalFile = null;
        try {
            rafJournalFile = new RandomAccessFile(this.journalFile, "rw");
            long fileLength = rafJournalFile.length();
            rafJournalFile.seek(fileLength);
            rafJournalFile.write(data.getBytes("windows-1250"));
            rafJournalFile.close();
            rafJournalFile = null;
            this.closeFileSafe(rafJournalFile);
        }
        catch (Throwable throwable) {
            this.closeFileSafe(rafJournalFile);
            throw throwable;
        }
        this.journalFileRead(0);
    }

    private synchronized void journalFileClear() {
        RandomAccessFile rafJournalFile = null;
        try {
            rafJournalFile = new RandomAccessFile(this.journalFile, "rw");
            rafJournalFile.setLength(0L);
            rafJournalFile.close();
            rafJournalFile = null;
            this.closeFileSafe(rafJournalFile);
        }
        catch (Exception e2) {
            try {
                TngUtilities.exceptionLog(e2);
                this.closeFileSafe(rafJournalFile);
            }
            catch (Throwable throwable) {
                this.closeFileSafe(rafJournalFile);
                throw throwable;
            }
        }
    }

    private synchronized void closeFileSafe(RandomAccessFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (Throwable e2) {
                TngUtilities.exceptionLog(e2);
            }
        }
    }
}

