/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.net.InetAddress;
import tangram.library.TngConnection;
import tangram.library.TngLicence2;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngLicence2Validator {
    public static void loadAndCheck(TngLicence2 licence, TngConnection connection, int programMajorVersion) {
        TngLicence2Validator.loadAndCheck(licence, connection, programMajorVersion, false);
    }

    public static void loadAndCheck(TngLicence2 licence, TngConnection connection, int programMajorVersion, boolean silent) {
        String warning;
        licence.reset();
        String key = null;
        String id = null;
        try {
            key = (String)connection.queryObject("SELECT value FROM TNGSYS.TNGDATA WHERE loginname='*' and project='" + licence.getProject() + "' and key='LicenceKey'");
            id = TngLicence2.createDatabaseId(connection);
        }
        catch (Exception e2) {
            if (!silent) {
                TngSwing.exceptionShow(e2);
            }
            return;
        }
        licence.setKey(key);
        String error = licence.getError();
        if (!TngUtilities.isEmpty(error) && !silent) {
            TngSwing.msgError(error);
        }
        if ((warning = licence.check(id, programMajorVersion)) != null && !silent) {
            TngSwing.msgWarning(warning);
        }
    }

    public static boolean useOneLicgroup(TngConnection connection, String program, String licgroup, int maxComputers) {
        String sessionClient = TngLicence2Validator.getSessionClient();
        connection.setSessionInfo(sessionClient);
        boolean canUse = TngLicence2Validator.canUseLicgroup(connection, sessionClient, licgroup, maxComputers);
        program = TngUtilities.strLeft(program, 48);
        connection.setSessionName(program, canUse ? licgroup : "");
        return canUse;
    }

    private static boolean canUseLicgroup(TngConnection connection, String sessionClient, String licgroup, int maxComputers) {
        if (maxComputers < 1) {
            return false;
        }
        try {
            int hasLicgroup = connection.queryInt("SELECT 1 FROM TNGSYS.TNGLICENCE WHERE loginname=USER and licence='" + licgroup + "'");
            if (hasLicgroup < 1) {
                return false;
            }
            int used = connection.queryInt("SELECT COUNT(*) FROM (select null from V$SESSION where type='USER' and client_info<>'" + sessionClient + "' and action like '%" + licgroup + "%' group by client_info)");
            return used < maxComputers;
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
            return false;
        }
    }

    private static String getSessionClient() {
        try {
            String sessionClient = InetAddress.getLocalHost().getHostName();
            sessionClient = sessionClient.toUpperCase();
            return TngUtilities.strLeft(sessionClient, 64);
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
            return "CLIENT_" + TngUtilities.randomString(6);
        }
    }
}

