/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Point;
import tangram.library.TngUtilities;

public class TngOrder {
    public String name;
    public String title;
    public boolean asc;

    public TngOrder() {
    }

    public TngOrder(String name) {
        this(name, name, true);
    }

    public TngOrder(String name, String title) {
        this(name, title, true);
    }

    public TngOrder(String name, String title, boolean asc) {
        this.name = name;
        this.title = title;
        this.asc = asc;
        if (title == null || title.length() == 0) {
            this.title = name;
        }
    }

    public String toString() {
        return this.title + (this.asc ? " (Asc)" : " (Desc)");
    }

    public String createExpression() {
        return TngOrder.createExpression(this.name, this.asc);
    }

    public static String createExpression(String name, boolean asc) {
        if (asc) {
            return name;
        }
        return name + " DESC";
    }

    public static String syntetizeOrder(TngOrder[] o2) {
        if (o2 == null || o2.length == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder(64);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            if (i2 > 0) {
                buff.append(',');
            }
            buff.append(o2[i2].createExpression());
        }
        return buff.toString();
    }

    public static TngOrder[] analyzeOrder(String order) {
        String[] items = TngUtilities.strTokenizeNotNull(order, ',');
        TngOrder[] o2 = new TngOrder[items.length];
        int n2 = 0;
        for (int i2 = 0; i2 < items.length; ++i2) {
            String column = items[i2].trim();
            if (column.length() == 0) continue;
            boolean asc = true;
            String upper = column.toUpperCase();
            if (upper.endsWith(" ASC")) {
                column = TngUtilities.strCutEnd(column, 4).trim();
            } else if (upper.endsWith(" DESC")) {
                asc = false;
                column = TngUtilities.strCutEnd(column, 5).trim();
            }
            o2[n2++] = new TngOrder(column, column, asc);
        }
        if (o2.length == n2) {
            return o2;
        }
        TngOrder[] oo = new TngOrder[n2];
        System.arraycopy(o2, 0, oo, 0, n2);
        return oo;
    }

    public static int findByName(TngOrder[] o2, String name) {
        if (o2 == null || name == null) {
            return -1;
        }
        for (int i2 = 0; i2 < o2.length; ++i2) {
            if (!name.equals(o2[i2].name)) continue;
            return i2;
        }
        return -1;
    }

    public static String changeOrderSimple(String order, String name) {
        if (name == null || name.length() == 0) {
            return order;
        }
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        int f2 = TngOrder.findByName(o2, name);
        boolean asc = true;
        if (f2 >= 0) {
            asc = !o2[f2].asc;
        }
        return TngOrder.createExpression(name, asc);
    }

    public static String changeOrderMulti(String order, String name) {
        if (name == null || name.length() == 0) {
            return order;
        }
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        int f2 = TngOrder.findByName(o2, name);
        if (f2 >= 0) {
            o2[f2].asc = !o2[f2].asc;
        }
        order = TngOrder.syntetizeOrder(o2);
        if (f2 < 0) {
            if (order.length() > 0) {
                order = order + ",";
            }
            order = order + TngOrder.createExpression(name, true);
        }
        return order;
    }

    public static int findInOrder(String order, String name, Point p2) {
        if (p2 != null) {
            p2.setLocation(0, 0);
        }
        if (order == null || order.length() == 0 || name == null || name.length() == 0) {
            return 0;
        }
        if (order.indexOf(name) < 0) {
            return 0;
        }
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        p2.y = o2.length;
        int f2 = TngOrder.findByName(o2, name);
        if (f2 < 0) {
            return 0;
        }
        if (p2 != null) {
            p2.x = f2 + 1;
        }
        return o2[f2].asc ? 1 : -1;
    }

    public static String normalize(String order) {
        if (order == null) {
            return "";
        }
        if (order.length() == 0) {
            return order;
        }
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        return TngOrder.syntetizeOrder(o2);
    }
}

