/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import tangram.library.TngConnection;
import tangram.library.TngParams;

public abstract class TngParamsAccessorSql
implements TngParams.TngParamsAccessor {
    private TngConnection connection;

    public void setConnection(TngConnection connection) {
        this.connection = connection;
    }

    public TngConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(TngParams p2) throws Exception {
        p2.clear();
        Statement st = null;
        try {
            String loadSql = this.getLoadSql(p2.getPath());
            st = this.connection.execStatement(loadSql);
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                this.loadRecord(p2, rs);
            }
            this.connection.close(st);
        }
        catch (Throwable throwable) {
            this.connection.close(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(TngParams p2) throws Exception {
        PreparedStatement st = null;
        boolean rollback = false;
        try {
            String deleteSql = this.getDeleteSql(p2.getPath());
            this.connection.exec(deleteSql);
            rollback = true;
            String insertSql = this.getInsertSql(p2.getPath());
            st = this.connection.prepareStatement(insertSql);
            Enumeration<String> e2 = p2.params.keys();
            while (e2.hasMoreElements()) {
                String fullname = e2.nextElement();
                if (!p2.isOnPath(fullname)) continue;
                this.insertRecord(st, fullname, p2.params.get(fullname));
            }
            this.connection.commit();
            rollback = false;
            if (rollback) {
                this.connection.rollback();
            }
            this.connection.close(st);
        }
        catch (Throwable throwable) {
            if (rollback) {
                this.connection.rollback();
            }
            this.connection.close(st);
            throw throwable;
        }
    }

    protected abstract String getLoadSql(String var1);

    protected abstract void loadRecord(TngParams var1, ResultSet var2) throws Exception;

    protected abstract String getDeleteSql(String var1);

    protected abstract String getInsertSql(String var1);

    protected abstract void insertRecord(PreparedStatement var1, String var2, String var3) throws Exception;
}

