/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.util.Map;
import java.util.StringTokenizer;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngSettingsController {
    public static String TNGVAR_VALUE = "";
    public static String TNGVAR_KLUC = "";
    public static String TNGVAR_UZIVATEL;

    public static void load(TngConnection tdb, String query) {
        Object obj = tdb.queryObjectWet(query);
        TNGVAR_VALUE = obj == null ? "" : obj.toString();
    }

    public static String getString(String key, String defaultValue) {
        StringTokenizer tokenizer = new StringTokenizer(TNGVAR_VALUE, "}");
        while (tokenizer.hasMoreTokens()) {
            int valueOffset = 0;
            String token = tokenizer.nextToken().trim();
            for (int i2 = 0; i2 < token.length(); ++i2) {
                if (token.charAt(i2) != '{') continue;
                valueOffset = i2;
            }
            String tokenKey = token.substring(0, valueOffset).trim();
            if (!tokenKey.equals(key)) continue;
            return token.substring(valueOffset + 1);
        }
        return defaultValue;
    }

    public static int getInt(String key, int defaultValue) {
        String value = TngSettingsController.getString(key, null);
        if (value != null) {
            return TngUtilities.strToInt(value, defaultValue);
        }
        return defaultValue;
    }

    public static String getSettingsFromMap(Map data) {
        StringBuilder ret = new StringBuilder();
        Object[] keys = data.keySet().toArray();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            ret.append(keys[i2] + "{" + data.get(keys[i2]) + "} ");
        }
        return ret.toString();
    }
}

