/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import tangram.exception.TngExceptionSql;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngSqlUtilities {
    public static void readRegularTables(TngConnection connection, String schema, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT table_name FROM all_tables where owner='" + schema + "' and temporary='N' ORDER BY table_name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPrimaryOrders(TngConnection connection, String schema, Map<String, String> orders) throws Exception {
        orders.clear();
        Statement st = null;
        try {
            String select = "select C.table_name,listagg(C.column_name||' '||C.descend,',') WITHIN GROUP (ORDER BY C.column_position) as index_order";
            select = select + "\nfrom all_indexes I";
            select = select + "\njoin all_ind_columns C on I.table_owner=C.table_owner and I.table_name=C.table_name and I.owner=C.index_owner and I.index_name=C.index_name";
            select = select + "\nwhere I.owner=I.table_owner and I.table_owner='" + schema + "' and I.uniqueness='UNIQUE' and I.index_type='NORMAL'";
            select = select + "\ngroup by C.table_name,C.index_name";
            select = select + "\norder by C.table_name,length(C.index_name)";
            st = connection.execStatement(select);
            ResultSet res = st.getResultSet();
            String lastTable = null;
            while (res.next()) {
                String table = res.getString(1);
                String order = res.getString(2);
                if (!table.equals(lastTable)) {
                    orders.put(table, order);
                }
                lastTable = table;
            }
        }
        catch (Throwable throwable) {
            connection.commit();
            connection.close(st);
            throw throwable;
        }
        connection.commit();
        connection.close(st);
    }

    public static String readPrimaryOrder(TngConnection connection, String schema, String table) throws TngExceptionSql {
        String select = "select listagg(C.column_name||' '||C.descend,',') WITHIN GROUP (ORDER BY C.column_position) as index_order";
        select = select + "\nfrom all_indexes I";
        select = select + "\njoin all_ind_columns C on I.table_owner=C.table_owner and I.table_name=C.table_name and I.owner=C.index_owner and I.index_name=C.index_name";
        select = select + "\nwhere I.owner=I.table_owner and I.table_owner='" + schema + "' and I.table_name='" + table + "' and I.uniqueness='UNIQUE' and I.index_type='NORMAL'";
        select = select + "\ngroup by C.index_name";
        Object o2 = connection.queryObject(select = select + "\norder by length(C.index_name)");
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    public static String[] readPrimaryColumns(TngConnection connection, String schema, String table) throws TngExceptionSql {
        String select = "select listagg(C.column_name,',') WITHIN GROUP (ORDER BY C.column_position) as index_columns";
        select = select + "\nfrom all_indexes I";
        select = select + "\njoin all_ind_columns C on I.table_owner=C.table_owner and I.table_name=C.table_name and I.owner=C.index_owner and I.index_name=C.index_name";
        select = select + "\nwhere I.owner=I.table_owner and I.table_owner='" + schema + "' and I.table_name='" + table + "' and I.uniqueness='UNIQUE' and I.index_type='NORMAL'";
        select = select + "\ngroup by C.index_name";
        Object o2 = connection.queryObject(select = select + "\norder by length(C.index_name)");
        if (o2 == null) {
            return null;
        }
        return TngUtilities.strTokenizeOrNull(o2.toString(), ',');
    }

    public static void truncateTable(TngConnection connection, String table) throws TngExceptionSql {
        try {
            connection.exec("TRUNCATE TABLE " + table);
            return;
        }
        catch (TngExceptionSql tngExceptionSql) {
            connection.exec("DELETE FROM " + table);
            connection.commit();
            return;
        }
    }

    public static boolean disableTriggersSafe(TngConnection connection, String schemaAndTable) {
        try {
            connection.exec("ALTER TABLE " + schemaAndTable + " DISABLE ALL TRIGGERS");
            return true;
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
            return false;
        }
    }

    public static boolean enableTriggersSafe(TngConnection connection, String schemaAndTable) {
        try {
            connection.exec("ALTER TABLE " + schemaAndTable + " ENABLE ALL TRIGGERS");
            return true;
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
            return false;
        }
    }
}

