/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import tangram.exception.TngException;
import tangram.exception.TngExceptionSql;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngSys {
    public static final String SCHEMA_NAME = "TNGSYS";
    public static final String KEY_VERSION = "TngsysVersion";
    public static final String VALUE_STAR = "*";
    public static final String UNKNOWN_PROJECT = "???";
    public static final BigDecimal VERSION = new BigDecimal("1.02");
    public static final LinkedHashMap<String, String> LICENCE_EKO = new LinkedHashMap();
    public static final LinkedHashMap<String, String> LICENCE_EDS = new LinkedHashMap();
    protected TngConnection conn;
    protected boolean accessesEnabled;

    public void setConn(TngConnection conn) {
        this.conn = conn;
    }

    public boolean schemaSysExists() throws Exception {
        String query = "SELECT count(*) FROM all_users WHERE username='TNGSYS'";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        int count = this.conn.queryInt(query);
        return count != 0;
    }

    public BigDecimal getSchemaSysVersion() throws Exception {
        String query = "SELECT max(value) FROM TNGSYS.tngdata WHERE key='TngsysVersion' AND loginname='*' AND project='*' ORDER BY value DESC";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        Object value = this.conn.queryObjectWet(query);
        BigDecimal version = TngUtilities.stringToNumber(value == null ? null : value.toString());
        return version;
    }

    public void setAccessesEnabled() throws Exception {
        String query = "SELECT count(*) FROM TNGSYS.tngaccess";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        int count = this.conn.queryInt(query);
        this.accessesEnabled = count != 0;
    }

    public boolean isUserTangram(String loginname) throws Exception {
        String query = "SELECT count(*) FROM TNGSYS.tnglogins where loginname='" + loginname + "' AND work='T'";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        int count = this.conn.queryInt(query);
        return count != 0;
    }

    public void check(String loginname) throws Exception {
        if (!this.schemaSysExists()) {
            throw new Exception(Nat.x("Sch\u00e9ma %1 neexistuje", SCHEMA_NAME));
        }
        BigDecimal version = this.getSchemaSysVersion();
        if (version == null) {
            throw new Exception(Nat.x("Nebol najden\u00fd \u017eiaden z\u00e1znam s verziou sch\u00e9my %1", SCHEMA_NAME));
        }
        if (version.compareTo(VERSION) != 0) {
            throw new Exception(Nat.x("Aktu\u00e1lna verzia sch\u00e9my %1 je %2, vy\u017eaduje sa verzia %3", SCHEMA_NAME, version, VERSION));
        }
        if (!this.isUserTangram(loginname)) {
            throw new Exception(Nat.x("Pou\u017e\u00edvate\u013e %1 nie je pou\u017e\u00edvate\u013eom Tangramu", loginname));
        }
        this.setAccessesEnabled();
    }

    protected TngConnection connectSchemaSys(String password) throws TngException {
        try {
            TngConnection connSchema = TngConnection.copy(this.conn);
            connSchema.setUser(SCHEMA_NAME);
            connSchema.setPassword(password);
            connSchema.setSchema(SCHEMA_NAME);
            connSchema.connect();
            return connSchema;
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, Nat.x("Chyba pri vytv\u00e1ran\u00ed datab\u00e1zov\u00e9ho spojenia so sch\u00e9mou %1", SCHEMA_NAME));
        }
    }

    public void loadSchemas(String project, List<String> schemas) throws TngException {
        String query = "SELECT schema FROM TNGSYS.tngschemas where project='" + project + "' order by schema";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        this.conn.addQueryRows(schemas, query);
    }

    public boolean hasAccess(String loginname, String schema, String project) throws TngException {
        if (!this.accessesEnabled) {
            return true;
        }
        String anySchema = VALUE_STAR + project;
        String query = "SELECT count(*) FROM TNGSYS.tngaccess WHERE loginname='" + loginname + "' AND (schema='" + anySchema + "' or schema='" + schema + "')";
        if (this.conn == null) {
            throw new TngExceptionSql(TngConnection.NO_CONNECTION, query);
        }
        int count = this.conn.queryInt(query);
        return count != 0;
    }

    static {
        LICENCE_EKO.put("EOS", Nat.x("Ekonomicko-obchodn\u00fd syst\u00e9m"));
        LICENCE_EKO.put("EKO", Nat.x("Ekonomika"));
        LICENCE_EKO.put("SKL", Nat.x("Obchod"));
        LICENCE_EKO.put("FIN", Nat.x("Financie"));
        LICENCE_EKO.put("FAP", Nat.x("Fakt\u00fary prijat\u00e9"));
        LICENCE_EKO.put("POS", Nat.x("Po\u0161ta"));
        LICENCE_EKO.put("OBJ", Nat.x("Objedn\u00e1vky"));
        LICENCE_EKO.put("KAL", Nat.x("Normy"));
        LICENCE_EKO.put("ASE", Nat.x("Autoservis"));
        LICENCE_EKO.put("PED", Nat.x("Pe\u0148a\u017en\u00fd denn\u00edk"));
        LICENCE_EKO.put("EDI", Nat.x("EDI"));
        LICENCE_EKO.put("SPD", Nat.x("\u0160ped\u00edcia"));
        LICENCE_EDS.put("EDS", Nat.x("Doch\u00e1dzka"));
    }
}

