/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangram.library.Nat;
import tangram.library.TngConfigAbstract;
import tangram.library.TngUtilities;

public class TngTnsnamesConfig
extends TngConfigAbstract {
    public static final String SQL_INI = "sql.ini";
    private static final String TNS_ORA = "tnsnames.ora";
    private File oraClientFile;
    private List<TngTnsnamesRecord> tnsRecords = new ArrayList<TngTnsnamesRecord>();

    public TngTnsnamesConfig(String fileName) {
        super(fileName);
    }

    @Override
    public void iniLoad() throws Exception {
        if (!this.iniLoaded) {
            File cFile = new File(SQL_INI);
            if (!cFile.exists()) {
                throw new Exception(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neexistuje", SQL_INI));
            }
            this.ini.load();
            this.loadOraClient();
            this.loadTnsRecords();
            this.iniLoaded = true;
        }
    }

    @Override
    public String[] getDatabases() throws Exception {
        this.iniLoad();
        String[] dbs = new String[this.tnsRecords.size()];
        for (int i2 = 0; i2 < this.tnsRecords.size(); ++i2) {
            TngTnsnamesRecord r2 = this.tnsRecords.get(i2);
            dbs[i2] = r2.key;
        }
        return dbs;
    }

    @Override
    protected String getString(String section, String key, String defValue) throws Exception {
        String h2 = TngUtilities.getArgumentString(key, null);
        if (h2 != null) {
            return h2;
        }
        TngTnsnamesRecord record = this.findTnsnamesRecord(section);
        if (record == null) {
            return defValue;
        }
        return record.getString(key, defValue);
    }

    @Override
    protected int getInteger(String section, String key, int defValue) throws Exception {
        int h2 = TngUtilities.getArgumentInteger(key, 0);
        if (h2 > 0) {
            return h2;
        }
        TngTnsnamesRecord record = this.findTnsnamesRecord(section);
        if (record == null) {
            return defValue;
        }
        return record.getInteger(key, defValue);
    }

    private void loadOraClient() throws Exception {
        String oraClientDir = this.getOraClientDir();
        if (oraClientDir == null || oraClientDir.length() == 0) {
            throw new Exception(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neobsahuje v sekcii 'tangram' polo\u017eku 'oracle_home'", SQL_INI));
        }
        this.oraClientFile = this.getTnsNamesOraFile(oraClientDir);
    }

    private String getOraClientDir() throws Exception {
        return this.ini.getString("tangram", "oracle_home", null);
    }

    private File getTnsNamesOraFile(String tnsNamesOraDir) throws Exception {
        String oraDir = tnsNamesOraDir + "\\" + TNS_ORA;
        File cFile = TngUtilities.getFileAppFull(oraDir);
        if (!cFile.exists()) {
            throw new Exception(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neexistuje", oraDir));
        }
        return cFile;
    }

    private void loadTnsRecords() throws Exception {
        String[] gates = this.ini.getValues("oragtwy", "remotedbname");
        if (gates.length == 0) {
            throw new Exception(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neobsahuje polo\u017eky 'remotedbname' v sekcii 'oragtwy'", SQL_INI));
        }
        this.tnsRecords.clear();
        for (String g2 : gates) {
            String[] toks;
            if (g2.length() == 0 || (toks = TngUtilities.strTokenizeOrNull(g2, ',')) == null || toks.length != 2) continue;
            TngTnsnamesRecord record = new TngTnsnamesRecord();
            record.key = toks[0].trim();
            record.name = toks[1].trim().replace("@", "");
            try {
                this.loadTnsRecord(record);
                this.tnsRecords.add(record);
            }
            catch (Exception e2) {
                TngUtilities.errorLog(e2.getMessage());
            }
        }
    }

    private void loadTnsRecord(TngTnsnamesRecord record) throws Exception {
        String tnsDesc = this.getTnsNamesOraDesc(this.oraClientFile, record.name);
        if (tnsDesc == null || tnsDesc.length() == 0) {
            throw new Exception(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neobsahuje popis datab\u00e1zy '%2'", TNS_ORA, record.name));
        }
        record.analyzeDesc(tnsDesc);
    }

    private String getTnsNamesOraDesc(File tnsNamesOra, String tnsName) throws Exception {
        block1: {
            String dbDesc;
            String dbName;
            String desc = TngTnsnamesConfig.readFile(tnsNamesOra);
            desc = TngTnsnamesConfig.optimalize(desc);
            int from = 0;
            do {
                int ioEqual = desc.indexOf("=", from);
                int ioRight = TngTnsnamesConfig.nthOccurrence(desc, ')', 7, from);
                if (ioEqual == -1 || ioRight == -1) break block1;
                dbName = desc.substring(from, ioEqual).trim();
                dbDesc = desc.substring(ioEqual + 1, ioRight).trim();
                from = ioRight + 1;
            } while (!dbName.equalsIgnoreCase(tnsName));
            return dbDesc;
        }
        return null;
    }

    private static int nthOccurrence(String str, char c2, int n2, int from) {
        int pos = str.indexOf(c2, from);
        while (n2-- > 0 && pos != -1) {
            pos = str.indexOf(c2, pos + 1);
        }
        return pos;
    }

    private static String optimalize(String s2) {
        s2 = s2.replace(" ", "");
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws Exception {
        StringBuilder sb = new StringBuilder();
        String str = null;
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if (str.trim().startsWith("#") || str.trim().startsWith(";")) continue;
                sb.append(str.trim());
            }
        }
        return sb.toString();
    }

    private TngTnsnamesRecord findTnsnamesRecord(String key) {
        if (key == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.tnsRecords.size(); ++i2) {
            TngTnsnamesRecord r2 = this.tnsRecords.get(i2);
            if (!key.equalsIgnoreCase(r2.key)) continue;
            return r2;
        }
        return null;
    }

    private static class TngTnsnamesRecord {
        private String key;
        private String name;
        public Map<String, String> desc = new HashMap<String, String>();

        private TngTnsnamesRecord() {
        }

        private void analyzeDesc(String tnsDesc) {
            tnsDesc = tnsDesc.toLowerCase();
            this.desc.put("protocol", this.getParamString(tnsDesc, "protocol", "TCP"));
            this.desc.put("host", this.getParamString(tnsDesc, "host", "localhost"));
            this.desc.put("port", this.getParamString(tnsDesc, "port", "1521"));
            this.desc.put("server", this.getParamString(tnsDesc, "server", "dedicated"));
            this.desc.put("service", this.getParamString(tnsDesc, "service_name", "XE"));
        }

        private String getParamString(String tnsDesc, String paramName, String defaulValue) {
            int ioEqual = tnsDesc.indexOf(paramName + "=");
            if (ioEqual == -1) {
                return defaulValue;
            }
            int ioRight = tnsDesc.indexOf(41, ioEqual);
            if (ioRight == -1) {
                return defaulValue;
            }
            return tnsDesc.substring(ioEqual + paramName.length() + 1, ioRight);
        }

        private String getString(String key, String defValue) {
            String h2 = this.desc.get(key);
            if (h2 == null) {
                return defValue;
            }
            return h2;
        }

        public int getInteger(String key, int defValue) {
            String h2 = this.desc.get(key);
            if (h2 == null) {
                return defValue;
            }
            int v2 = TngUtilities.strToInt(h2, -1);
            if (v2 < 0) {
                throw new NumberFormatException(Nat.nox("Hodnota %1 je mimo povolen\u00fd rozsah", h2));
            }
            return v2;
        }
    }
}

