/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import tangram.library.TngUtilities;

public class TngUoPeriod {
    private int year;
    private int month;
    private int day;

    private TngUoPeriod() {
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date asDate() {
        return TngUtilities.dateCreate(this.year, this.month, this.day);
    }

    public Calendar asCal() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.asDate());
        return cal;
    }

    public static TngUoPeriod fromString(String uoPeriodStr) {
        TngUoPeriod uoPeriod = new TngUoPeriod();
        if (TngUtilities.isEmpty(uoPeriodStr) || uoPeriodStr.length() != 8) {
            return null;
        }
        int year = TngUtilities.strToInt(TngUtilities.strLeft(uoPeriodStr, 4), -1);
        if (year == -1) {
            return null;
        }
        uoPeriod.year = year;
        int month = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(uoPeriodStr, 4, 2), -1);
        if (month == -1 || month < 1 || month > 12) {
            return null;
        }
        uoPeriod.month = month;
        int day = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(uoPeriodStr, 6, 2), -1);
        if (day == -1 || day < 1 || day > 31) {
            return null;
        }
        uoPeriod.day = day;
        return uoPeriod;
    }
}

