/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import tangram.library.TngUtilities;

public class TngXlsWorkbook {
    public static final String FILE_EXTENSION_XLS = "xls";
    public static final String FILE_EXTENSION_XLSX = "xlsx";
    public static final int MAX_ROWS_PER_SHEET = Short.MAX_VALUE;
    protected File file;
    protected Workbook workbook;
    protected String[] columns;
    protected CellStyle dateStyle;
    protected CellStyle dateTimeStyle;

    public void setData(File file, String[] columns) throws Exception {
        this.file = file;
        this.columns = columns;
        this.resolveWorkbook();
        this.prepareDataStyles();
    }

    public boolean isSXSSF() {
        return this.workbook instanceof SXSSFWorkbook;
    }

    public Sheet createSheetWithHeader(int sheetNumber) throws Exception {
        Sheet sheet = this.workbook.createSheet("Data_" + sheetNumber);
        sheet.getPrintSetup().setLandscape(false);
        sheet.getPrintSetup().setPaperSize((short)9);
        this.createHeaderRows(sheet);
        return sheet;
    }

    protected void createHeaderRows(Sheet sheet) throws Exception {
        this.createHeaderRow(sheet);
    }

    protected void createHeaderRow(Sheet sheet) throws Exception {
        Row rowHeader1 = sheet.createRow(0);
        rowHeader1.setHeightInPoints(20.0f);
        CellStyle style = this.createHeaderStyle();
        for (int col = 0; col < (this.columns == null ? 0 : this.columns.length); ++col) {
            Cell cell = rowHeader1.createCell(col);
            cell.setCellStyle(style);
            this.createHeaderRowCell(cell, col);
        }
    }

    protected void createHeaderRowCell(Cell cell, int columnIndex) throws Exception {
        if (this.columns != null) {
            cell.setCellValue(this.columns[columnIndex]);
        }
    }

    protected CellStyle createHeaderStyle() throws Exception {
        Font font = this.workbook.createFont();
        font.setBoldweight((short)700);
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment((short)2);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setFont(font);
        return style;
    }

    public void setCellValueByType(Cell cell, Object value) throws Exception {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date) {
            CellStyle cellStyle = TngXlsWorkbook.isDatetime((Date)value) ? this.dateTimeStyle : this.dateStyle;
            cell.setCellStyle(cellStyle);
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue((Boolean)value);
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public void autoSizeSheetsColumns() throws Exception {
        int sheetsCount = this.workbook.getNumberOfSheets();
        for (int i2 = 0; i2 < sheetsCount; ++i2) {
            Sheet sheet = this.workbook.getSheetAt(i2);
            for (int colIdx = 0; colIdx < (this.columns == null ? 0 : this.columns.length); ++colIdx) {
                sheet.autoSizeColumn(colIdx);
            }
        }
    }

    public void write() throws Exception {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(this.file);
            this.workbook.write(fileOut);
            ((OutputStream)fileOut).close();
            fileOut = null;
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(fileOut);
            if (this.isSXSSF()) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
            throw throwable;
        }
        TngUtilities.streamCloseSafe(fileOut);
        if (this.isSXSSF()) {
            ((SXSSFWorkbook)this.workbook).dispose();
        }
    }

    protected void resolveWorkbook() throws Exception {
        String fileExt = TngXlsWorkbook.getFileExtension(this.file, FILE_EXTENSION_XLS);
        if (FILE_EXTENSION_XLSX.equalsIgnoreCase(fileExt)) {
            this.workbook = new SXSSFWorkbook(200);
            ((SXSSFWorkbook)this.workbook).setCompressTempFiles(true);
        } else {
            this.workbook = new HSSFWorkbook();
        }
    }

    protected void prepareDataStyles() {
        CreationHelper createHelper = this.workbook.getCreationHelper();
        DataFormat dataFormat = createHelper.createDataFormat();
        this.dateStyle = this.workbook.createCellStyle();
        this.dateStyle.setDataFormat(dataFormat.getFormat("dd.mm.yyyy"));
        this.dateTimeStyle = this.workbook.createCellStyle();
        this.dateTimeStyle.setDataFormat(dataFormat.getFormat("dd.mm.yyyy hh:mm:ss"));
    }

    public static String getFileExtension(File file, String defaultFileExtension) throws Exception {
        String fileName = file.getName();
        int indexOfPoint = fileName.lastIndexOf(".");
        if (indexOfPoint == -1 || indexOfPoint == fileName.length() - 1) {
            return defaultFileExtension;
        }
        return fileName.substring(indexOfPoint + 1);
    }

    public static boolean isDatetime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int h2 = cal.get(10);
        int m2 = cal.get(12);
        int s2 = cal.get(13);
        return h2 != 0 || m2 != 0 || s2 != 0;
    }
}

