/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangram.library.TngUtilities;

public class TngBysquareParams {
    public static final char PARAM_DIVIDER = '=';
    public static final char PARAM_END = '\n';
    private Map<String, String> params = new HashMap<String, String>();

    public void encode(String paramsValue) {
        String[] paramsTokens;
        for (String paramsToken : paramsTokens = TngUtilities.strTokenizeNotNull(paramsValue, '\n')) {
            int indexOfParamDivider = paramsToken.indexOf(61);
            if (indexOfParamDivider == -1) continue;
            String key = TngUtilities.strLeft(paramsToken, indexOfParamDivider);
            String value = TngUtilities.strCut(paramsToken, indexOfParamDivider + 1);
            this.params.put(key, value);
        }
    }

    public String decode() {
        StringBuilder paramsValue = new StringBuilder();
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            String key = param.getKey().toUpperCase();
            String value = param.getValue();
            paramsValue.append(key + '=' + (value == null ? "" : value) + '\n');
        }
        return paramsValue.toString();
    }

    public String getString(String name) {
        if (name == null) {
            return null;
        }
        if (!this.params.containsKey(name.toUpperCase())) {
            return null;
        }
        return this.params.get(name.toUpperCase());
    }

    public String getString(Enum<?> item) {
        return item == null ? null : this.getString(item.name());
    }

    public BigDecimal getBigDecimal(String name) {
        String strValue = this.getString(name);
        return TngUtilities.stringToNumber(strValue);
    }

    public BigDecimal getBigDecimal(Enum<?> item) {
        return item == null ? null : this.getBigDecimal(item.name());
    }

    public Integer getInteger(String name) {
        String strValue = this.getString(name);
        int intValue = TngUtilities.strToInt(strValue, Integer.MIN_VALUE);
        return intValue == Integer.MIN_VALUE ? null : Integer.valueOf(intValue);
    }

    public Integer getInteger(Enum<?> item) {
        return item == null ? null : this.getInteger(item.name());
    }

    public Integer getIntegerDef(String name, int defIntValue) {
        String strValue = this.getString(name);
        return TngUtilities.strToInt(strValue, defIntValue);
    }

    public Integer getIntegerDef(Enum<?> item, int defIntValue) {
        return item == null ? defIntValue : this.getIntegerDef(item.name(), defIntValue);
    }

    public Date getDate(String name) {
        String strValue = this.getString(name);
        return TngUtilities.strToDate(strValue);
    }

    public Date getDate(Enum<?> item) {
        return item == null ? null : this.getDate(item.name());
    }

    public void setString(String name, String value) {
        this.params.put(name, value);
    }

    public void setString(Enum<?> item, String value) {
        if (item != null) {
            this.setString(item.name(), value);
        }
    }

    public void setBigDecimal(String name, BigDecimal value) {
        this.params.put(name, TngUtilities.numberToString(value));
    }

    public void setBigDecimal(Enum<?> item, BigDecimal value) {
        if (item != null) {
            this.setBigDecimal(item.name(), value);
        }
    }

    public void setInteger(String name, Integer value) {
        this.params.put(name, value == null ? null : String.valueOf(value));
    }

    public void setInteger(Enum<?> item, Integer value) {
        if (item != null) {
            this.setInteger(item.name(), value);
        }
    }

    public void setDate(String name, Date value) {
        this.params.put(name, TngUtilities.dateToStr(value));
    }

    public void setDate(Enum<?> item, Date value) {
        if (item != null) {
            this.setDate(item.name(), value);
        }
    }
}

