/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import com.bysquare.document.pay.BankAccount;
import com.bysquare.document.pay.BankAccounts;
import com.bysquare.document.pay.DirectDebitExt;
import com.bysquare.document.pay.DirectDebitScheme;
import com.bysquare.document.pay.DirectDebitType;
import com.bysquare.document.pay.Month;
import com.bysquare.document.pay.Pay;
import com.bysquare.document.pay.Payment;
import com.bysquare.document.pay.PaymentOption;
import com.bysquare.document.pay.Payments;
import com.bysquare.document.pay.Periodicity;
import com.bysquare.document.pay.StandingOrderExt;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import tangram.qrcode.TngBysquareUtils;

public class TngPayBysquareFactory {
    public static Pay createPay(String invoiceId, Payments payments) {
        Pay pay = new Pay();
        pay.setInvoiceID(invoiceId);
        pay.setPayments(payments);
        return pay;
    }

    public static Payment createPayment(List<PaymentOption> paymentOptions, BigDecimal amount, String currencyCode, Date paymentDueDate, String variableSymbol, String constantSymbol, String specificSymbol, String originatorsReferenceInformation, String paymentNote, BankAccounts bankAccounts, StandingOrderExt standingOrderExt, DirectDebitExt directDebitExt) {
        Payment payment = new Payment();
        payment.setPaymentOptions(paymentOptions);
        payment.setAmount(TngBysquareUtils.decimalToDouble(amount));
        payment.setCurrencyCode(currencyCode);
        payment.setPaymentDueDate(paymentDueDate);
        payment.setVariableSymbol(variableSymbol);
        payment.setConstantSymbol(constantSymbol);
        payment.setSpecificSymbol(specificSymbol);
        payment.setOriginatorsReferenceInformation(originatorsReferenceInformation);
        payment.setPaymentNote(paymentNote);
        payment.setBankAccounts(bankAccounts);
        payment.setStandingOrderExt(standingOrderExt);
        payment.setDirectDebitExt(directDebitExt);
        return payment;
    }

    public static BankAccount createBankAccount(String bankIban, String bankBic) {
        BankAccount bankAccount = new BankAccount();
        bankAccount.setIBAN(bankIban);
        bankAccount.setBIC(bankBic);
        return bankAccount;
    }

    public static StandingOrderExt createStandingOrderExt(Integer day, List<Month> months, Periodicity periodicity, Date lastDate) {
        StandingOrderExt standingOrderExt = new StandingOrderExt();
        standingOrderExt.setDay(day);
        standingOrderExt.setMonth(months);
        standingOrderExt.setPeriodicity(periodicity);
        standingOrderExt.setLastDate(lastDate);
        return standingOrderExt;
    }

    public static DirectDebitExt createDirectDebitExt(DirectDebitScheme directDebitScheme, DirectDebitType directDebitType, String variableSymbol, String specificSymbol, String originatorsReferenceInformation, String mandateID, String creditorID, String contractID, BigDecimal maxAmount, Date validTillDate) {
        DirectDebitExt directDebitExt = new DirectDebitExt();
        directDebitExt.setDirectDebitScheme(directDebitScheme);
        directDebitExt.setDirectDebitType(directDebitType);
        directDebitExt.setVariableSymbol(variableSymbol);
        directDebitExt.setSpecificSymbol(specificSymbol);
        directDebitExt.setOriginatorsReferenceInformation(originatorsReferenceInformation);
        directDebitExt.setMandateID(mandateID);
        directDebitExt.setCreditorID(creditorID);
        directDebitExt.setContractID(contractID);
        directDebitExt.setMaxAmount(TngBysquareUtils.decimalToDouble(maxAmount));
        directDebitExt.setValidTillDate(validTillDate);
        return directDebitExt;
    }
}

