/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRField;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.TngReportBind;
import tangram.swing.panel.TngProgressableWorker;

public class TngReportBindReader
implements JRDataSource {
    private File file;
    private HashMap<String, TngReportBind> binds;
    private BufferedReader reader;
    private StringBuilder dataRow;
    private TngProgressableWorker worker;
    private Exception nextException;
    private float progressFactor;
    private float readPosition;
    private int rowNumber;
    private boolean eof;

    public void open(File file, HashMap<String, TngReportBind> binds, TngProgressableWorker worker) throws Exception {
        long size;
        this.close();
        this.file = file;
        this.binds = binds;
        this.worker = worker;
        if (worker != null) {
            worker.setProgressCancelable(false);
            worker.setProgressMax(100);
        }
        this.progressFactor = (size = file.length()) <= 0L ? 0.0f : 100.0f / (float)size;
        this.readPosition = 0.0f;
        this.rowNumber = 0;
        this.eof = false;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "windows-1250"));
        this.dataRow = new StringBuilder();
        this.readRow();
        if (!this.dataRowStartsWith("#BEGIN")) {
            throw new Exception(Nat.x("D\u00e1tov\u00fd s\u00fabor tla\u010dovej zostavy %1 neza\u010d\u00edna #BEGIN", file.getAbsolutePath()));
        }
    }

    public void close() {
        TngUtilities.closeSafe(this.reader);
        this.reader = null;
        this.dataRow = null;
        this.worker = null;
        this.binds = null;
        this.file = null;
    }

    public HashMap<String, TngReportBind> getBinds() {
        return this.binds;
    }

    private boolean nextIntermal() throws Exception {
        if (this.eof) {
            return false;
        }
        this.readRow();
        if (this.dataRowStartsWith("#END")) {
            this.eof = true;
            return false;
        }
        while (this.dataRow.length() != 1 || this.dataRow.charAt(0) != '#') {
            this.setValue();
            this.readRow();
        }
        return true;
    }

    public boolean nextWithExceptionAndProgress() throws Exception {
        boolean ret = this.nextIntermal();
        if (this.worker != null) {
            this.worker.setProgressValue((int)(this.progressFactor * this.readPosition));
        }
        return ret;
    }

    private void readRow() throws Exception {
        this.dataRow.setLength(0);
        while (true) {
            int c2;
            if ((c2 = this.reader.read()) < 0) {
                throw new Exception(Nat.x("D\u00e1tov\u00fd s\u00fabor tla\u010dovej zostavy %1 je nespr\u00e1vne ukon\u010den\u00fd", this.file.getAbsolutePath()));
            }
            this.readPosition += 1.0f;
            if (c2 == 13) break;
            this.dataRow.append((char)c2);
        }
        ++this.rowNumber;
    }

    private boolean dataRowStartsWith(String startWith) {
        int n2 = startWith.length();
        if (this.dataRow.length() < n2 || this.dataRow.charAt(0) != startWith.charAt(0)) {
            return false;
        }
        String s2 = this.dataRow.substring(0, n2);
        return s2.startsWith(startWith, 0);
    }

    private void setValue() throws Exception {
        int p2 = this.charPostitionInRow(this.dataRow, '=');
        if (p2 <= 0) {
            throw new Exception(Nat.x("Chyba v %1. riadku d\u00e1tov\u00e9ho s\u00faboru %2", this.rowNumber, this.file.getAbsolutePath()));
        }
        String name = this.dataRow.substring(0, p2);
        TngReportBind bind = this.binds.get(name);
        if (bind == null) {
            return;
        }
        String value = this.dataRow.substring(p2 + 1);
        bind.setValue(value);
    }

    private int charPostitionInRow(StringBuilder data, char c2) {
        int n2 = data.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (data.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    public Exception getNextException() {
        return this.nextException;
    }

    @Override
    public boolean next() {
        try {
            return this.nextWithExceptionAndProgress();
        }
        catch (Exception e2) {
            this.nextException = e2;
            return false;
        }
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        TngReportBind bind = this.binds.get(jrField.getName());
        if (bind == null) {
            return null;
        }
        if (bind.value == null && bind.type == 0) {
            return "";
        }
        return bind.value;
    }
}

