/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.io.File;
import java.util.List;
import java.util.zip.ZipFile;
import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.krysalis.barcode4j.ChecksumMode;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.TngReport;

public class TngReportPreparer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareReport(JasperDesign jasperDesign) throws Exception {
        ZipFile zipFile = null;
        try {
            File customPath;
            File reportsZip = new File("reports.zip");
            if (reportsZip.isFile()) {
                zipFile = new ZipFile(reportsZip);
            }
            if (!(customPath = new File("custom")).isDirectory()) {
                customPath = null;
            }
            TngReportPreparer.resolveStyles(jasperDesign, zipFile, customPath);
            TngReportPreparer.resolveElemets(jasperDesign, zipFile, customPath);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    private static void resolveStyles(JasperDesign jasperDesign, ZipFile zipFile, File customPath) throws Exception {
        List<JRReportTemplate> templates = jasperDesign.getTemplatesList();
        for (int i2 = 0; i2 < templates.size(); ++i2) {
            JRDesignReportTemplate template = (JRDesignReportTemplate)templates.get(i2);
            JRDesignExpression exp = (JRDesignExpression)template.getSourceExpression();
            String style = TngReport.expresionToSingleString(exp);
            String url = TngReportPreparer.findFileUrl(style, zipFile, customPath);
            exp.setText(url);
        }
    }

    private static String findFileUrl(String file, ZipFile zipFile, File customPath) throws Exception {
        File fileStyle;
        String name = new File(file).getName();
        if (customPath != null && (fileStyle = new File(customPath, name)).exists()) {
            return TngReportPreparer.getUrlFileExpression(fileStyle);
        }
        if (zipFile != null) {
            if (zipFile.getEntry(name) != null) {
                return TngReportPreparer.getUrlZipFileExpression(zipFile, name);
            }
            throw new Exception(Nat.x("S\u00fabor %1 neexistuje v adres\u00e1ri CUSTOM ani v ZIP s\u00fabore %2", name, zipFile.getName()));
        }
        throw new Exception(Nat.x("S\u00fabor %1 neexistuje v adres\u00e1ri CUSTOM", name));
    }

    private static String getUrlFileExpression(File file) {
        String path = file.getAbsolutePath();
        path = path.replace('\\', '/');
        return "new URL(\"file:" + path + "\")";
    }

    private static String getUrlZipFileExpression(ZipFile zipFile, String zipEntry) {
        String path = zipFile.getName() + "!\\" + zipEntry;
        path = path.replace('\\', '/');
        return "new URL(\"jar:file:" + path + "\")";
    }

    private static void resolveElemets(JasperDesign jasperDesign, ZipFile zipFile, File customPath) throws Exception {
        JRBand[] bands = jasperDesign.getAllBands();
        if (bands == null) {
            return;
        }
        for (int i2 = 0; i2 < bands.length; ++i2) {
            JRDesignBand band = (JRDesignBand)bands[i2];
            List<JRChild> children = band.getChildren();
            int n2 = children.size();
            for (int c2 = 0; c2 < n2; ++c2) {
                JRChild child = children.get(c2);
                TngReportPreparer.resolveElementFormat(child);
                TngReportPreparer.resolveElementEan(band, child);
                TngReportPreparer.resolveElementImage(child, zipFile, customPath);
            }
        }
    }

    private static void resolveElementFormat(JRChild child) throws Exception {
        if (!(child instanceof JRDesignTextField)) {
            return;
        }
        JRDesignTextField field = (JRDesignTextField)child;
        String pattern = field.getPattern();
        if (pattern == null || pattern.length() <= 0 || !"styled".equals(field.getMarkup())) {
            return;
        }
        pattern = "'ALIGN_TO_DEC'" + pattern;
        field.setPattern(pattern);
    }

    private static void resolveElementImage(JRChild child, ZipFile zipFile, File customPath) throws Exception {
        String v2;
        if (!(child instanceof JRDesignImage)) {
            return;
        }
        JRDesignImage image = (JRDesignImage)child;
        JRDesignExpression expression = (JRDesignExpression)image.getExpression();
        String string = v2 = expression == null ? null : expression.getText();
        if (v2 == null || v2.length() < 3 || v2.charAt(0) != '\"' || v2.charAt(v2.length() - 1) != '\"') {
            return;
        }
        v2 = v2.substring(1, v2.length() - 1);
        String url = TngReportPreparer.findFileUrl(v2, zipFile, customPath);
        expression.setText(url);
    }

    private static void resolveElementEan(JRDesignBand band, JRChild child) throws Exception {
        if (!(child instanceof JRDesignComponentElement)) {
            return;
        }
        JRDesignComponentElement element = (JRDesignComponentElement)child;
        Component component = element.getComponent();
        if (!(component instanceof EAN13Component)) {
            return;
        }
        EAN13Component ean13 = (EAN13Component)component;
        EAN8Component ean8 = new EAN8Component();
        UPCAComponent upca = new UPCAComponent();
        TngReportPreparer.addAlternativeEan(band, (JRDesignComponentElement)child, ean13, ean8, "EAN8", 8);
        TngReportPreparer.addAlternativeEan(band, (JRDesignComponentElement)child, ean13, upca, "UPCA", 12);
        TngReportPreparer.eanPrintWhenExpression((JRDesignComponentElement)child, ean13, 13);
        ean13.setChecksumMode(ChecksumMode.CP_IGNORE);
        ean8.setChecksumMode(ChecksumMode.CP_IGNORE);
        upca.setChecksumMode(ChecksumMode.CP_IGNORE);
    }

    private static void addAlternativeEan(JRDesignBand band, JRDesignComponentElement origElement, EAN13Component origComponent, Barcode4jComponent newComponent, String name, int digits) {
        newComponent.setCodeExpression(origComponent.getCodeExpression());
        newComponent.setEvaluationGroup(origComponent.getEvaluationGroup());
        newComponent.setEvaluationTimeValue(origComponent.getEvaluationTimeValue());
        newComponent.setOrientation(origComponent.getOrientationValue());
        newComponent.setPatternExpression(origComponent.getPatternExpression());
        newComponent.setModuleWidth(origComponent.getModuleWidth());
        newComponent.setQuietZone(origComponent.getQuietZone());
        newComponent.setTextPosition(origComponent.getTextPositionValue());
        newComponent.setVerticalQuietZone(origComponent.getVerticalQuietZone());
        JRDesignComponentElement newElement = new JRDesignComponentElement();
        newElement = (JRDesignComponentElement)origElement.clone();
        newElement.setComponent(newComponent);
        newElement.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", name));
        TngReportPreparer.eanPrintWhenExpression(newElement, newComponent, digits);
        band.getChildren().add(newElement);
    }

    private static void eanPrintWhenExpression(JRDesignComponentElement element, Barcode4jComponent component, int digits) {
        JRDesignExpression expressionCode = (JRDesignExpression)component.getCodeExpression();
        String var = expressionCode == null ? null : expressionCode.getText();
        String when = "false";
        if (!TngUtilities.isEmpty(var)) {
            String origWhen;
            when = var + ".isLong()&&" + var + ".length()==" + digits;
            JRDesignExpression expressionPrint = (JRDesignExpression)element.getPrintWhenExpression();
            String string = origWhen = expressionPrint == null ? null : expressionPrint.getText();
            if (!TngUtilities.isEmpty(origWhen)) {
                when = "(" + origWhen + ")&&" + when;
            }
        }
        element.setPrintWhenExpression(new JRDesignExpression(when));
    }
}

