/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.panel.TngProgressableWorker;

public class TngReportPrinter
implements Printable {
    private JasperReportsContext jasperReportsContext;
    private JasperPrint jasperPrint;
    private PrintService printService;
    private TngProgressableWorker worker;
    private PrinterJob printerJob;
    private String printerName;
    private int firstPageIndex;
    private int lastPageIndex;
    private int copies;
    private boolean showPrintDialog;
    private int offset;

    public TngReportPrinter(JasperPrint jasperPrint) throws JRException {
        this.jasperPrint = jasperPrint;
        this.jasperReportsContext = DefaultJasperReportsContext.getInstance();
    }

    public void setData(String printerName, int firstPageIndex, int lastPageIndex, int copies, boolean showPrintDialog) {
        this.printerName = printerName;
        this.firstPageIndex = firstPageIndex;
        this.lastPageIndex = lastPageIndex;
        this.copies = copies;
        this.showPrintDialog = showPrintDialog;
    }

    public void setWorker(TngProgressableWorker worker) {
        this.worker = worker;
    }

    private void updateProgress(int pageIndex) {
        if (this.worker != null) {
            this.worker.setProgressStatus(Nat.x("Tla\u010d strany %1", pageIndex + 1));
        }
    }

    public boolean printPages() throws Exception {
        this.checkPageRange();
        this.printService = TngReportPrinter.getPrintService(this.printerName);
        this.printerJob = PrinterJob.getPrinterJob();
        this.printerJob.setPrintService(this.printService == null ? this.printerJob.getPrintService() : this.printService);
        this.printerJob.setCopies(this.copies);
        this.printerJob.setJobName("Tangram - " + this.jasperPrint.getName());
        PageFormat pageFormat = this.setPageFormat(this.printerJob);
        Book book = new Book();
        book.append(this, pageFormat, this.jasperPrint.getPages().size());
        this.printerJob.setPageable(book);
        if (this.showPrintDialog && !this.printerJob.printDialog()) {
            return false;
        }
        if (this.worker != null) {
            this.worker.setProgressMax(-1);
        }
        this.printerJob.print();
        return true;
    }

    private void checkPageRange() throws Exception {
        int pagesCount = this.jasperPrint.getPages().size();
        if (this.showPrintDialog) {
            this.firstPageIndex = 1;
            this.lastPageIndex = pagesCount;
        }
        if (this.firstPageIndex <= 0) {
            this.firstPageIndex = 1;
        }
        if (this.lastPageIndex <= 0) {
            this.lastPageIndex = pagesCount;
        }
        if (this.firstPageIndex > this.lastPageIndex || this.lastPageIndex > pagesCount) {
            throw new TngException(Nat.x("Nespr\u00e1vny rozsah str\u00e1n: %1 - %2, po\u010det str\u00e1n: %3", this.firstPageIndex, this.lastPageIndex, pagesCount));
        }
        --this.firstPageIndex;
        --this.lastPageIndex;
        if (!this.showPrintDialog) {
            this.offset = this.firstPageIndex;
        }
    }

    private PageFormat setPageFormat(PrinterJob printerJob) {
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        int pageWidth = this.jasperPrint.getPageWidth();
        int pageHeight = this.jasperPrint.getPageHeight();
        switch (this.jasperPrint.getOrientationValue()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(pageHeight, pageWidth);
                paper.setImageableArea(0.0, 0.0, pageHeight, pageWidth);
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(pageWidth, pageHeight);
                paper.setImageableArea(0.0, 0.0, pageWidth, pageHeight);
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.interrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if ((pageIndex += this.offset) < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        if (!this.showPrintDialog && pageIndex > this.lastPageIndex) {
            return 1;
        }
        this.updateProgress(pageIndex - this.offset);
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter(this.jasperReportsContext);
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
            exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, pageIndex);
            exporter.exportReport();
        }
        catch (JRException e2) {
            throw new PrinterException(e2.getMessage());
        }
        return 0;
    }

    public static PrintService getPrintService(String printerName) throws Exception {
        PrintService printService = TngReportPrinter.findPrintService(printerName);
        if (printService == null) {
            if (TngUtilities.isEmpty(printerName)) {
                throw new Exception(Nat.x("Nebola zisten\u00e1 \u017eiadna predvolen\u00e1 tla\u010diare\u0148"));
            }
            throw new Exception(Nat.x("Tla\u010diare\u0148 %1 nebola n\u00e1jden\u00e1", printerName));
        }
        return printService;
    }

    public static PrintService findPrintService(String printerName) {
        if (TngUtilities.isEmpty(printerName)) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i2 = 0; i2 < services.length; ++i2) {
            if (!services[i2].getName().equalsIgnoreCase(printerName)) continue;
            return services[i2];
        }
        return null;
    }

    public static String[] getPrinters() {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        String[] printers = new String[services.length + 1];
        printers[0] = Nat.x("Predvolen\u00e1 v syst\u00e9me");
        for (int i2 = 0; i2 < services.length; ++i2) {
            printers[i2 + 1] = services[i2].getName();
        }
        return printers;
    }
}

