/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import tangram.library.Nat;
import tangram.library.TngOrderNamed;
import tangram.library.TngUtilities;
import tangram.report.visual.TngReportParams;
import tangram.swing.TngSwing;
import tangram.swing.component.TngCheckBox;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngPanel;

public class TngReportPanelOrderByGroupBy
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngLabel jLabel3 = new TngLabel();
    private TngComboBox[] jGroupBys;
    private TngComboBox jOrderBy = new TngComboBox();
    private TngCheckBox jOrderReverse = new TngCheckBox();
    private TngFieldString jNote = new TngFieldString();
    private List<TngOrderNamed> definitionOrderBy;
    private List<TngOrderNamed> definitionGroupBy;

    public TngReportPanelOrderByGroupBy() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(492, 130));
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(Nat.x("Usporiada\u0165 pod\u013ea"));
        this.jLabel2.setText(Nat.x("Pozn\u00e1mka"));
        this.jLabel3.setText(Nat.x("Medzis\u00fa\u010dty"));
        this.jOrderReverse.setText(Nat.x("Prevr\u00e1ti\u0165 poradie"));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jOrderBy, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jOrderReverse, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 3, 3), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)this.jNote, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        TngSwing.setOptimalHeight(this);
    }

    public void init(List<TngOrderNamed> definitionOrderBy, List<TngOrderNamed> definitionGroupBy) {
        this.definitionOrderBy = definitionOrderBy;
        this.definitionGroupBy = definitionGroupBy;
        this.initOrderBy();
        this.initGroupBy();
    }

    private void initOrderBy() {
        this.jOrderBy.setEnabled(this.definitionOrderBy.size() != 0);
        this.jOrderReverse.setEnabled(this.definitionOrderBy.size() != 0);
        for (TngOrderNamed definitionOrderByItem : this.definitionOrderBy) {
            this.jOrderBy.addItem(definitionOrderByItem);
        }
    }

    private void initGroupBy() {
        int combosCount = Math.min(3, this.definitionGroupBy.size());
        this.jLabel3.setVisible(combosCount != 0);
        this.jGroupBys = new TngComboBox[combosCount];
        for (int i2 = 0; i2 < combosCount; ++i2) {
            this.jGroupBys[i2] = this.createCombobox(i2);
        }
    }

    private TngComboBox createCombobox(int pc) {
        TngComboBox comboBox = new TngComboBox();
        comboBox.addItem("");
        for (TngOrderNamed o2 : this.definitionGroupBy) {
            comboBox.addItem(o2);
        }
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelOrderByGroupBy.this.resolveGroupByDuplicate(e2);
            }
        });
        this.add((Component)comboBox, new GridBagConstraints(1, pc, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        return comboBox;
    }

    private void resolveGroupByDuplicate(ActionEvent e2) {
        TngComboBox source = (TngComboBox)e2.getSource();
        if (source.getSelectedIndex() == 0) {
            return;
        }
        for (TngComboBox jGroupBy : this.jGroupBys) {
            if (source == jGroupBy || !source.getSelectedItem().equals(jGroupBy.getSelectedItem())) continue;
            jGroupBy.setSelectedIndex(0);
        }
    }

    public void readParams(TngReportParams reportParams) {
        reportParams.note = this.jNote.getStringDef("");
        reportParams.orderBy = this.jOrderBy.isEnabled() ? ((TngOrderNamed)this.jOrderBy.getSelectedItem()).getOrder() : null;
        reportParams.orderByReversed = this.jOrderReverse.isEnabled() && this.jOrderReverse.isSelected();
        reportParams.groupBy = this.readParamGroupBy();
    }

    private String readParamGroupBy() {
        String groupByParam = "";
        for (int i2 = 0; i2 < this.jGroupBys.length; ++i2) {
            TngComboBox jGroupBy = this.jGroupBys[i2];
            if (jGroupBy.getSelectedIndex() == 0) continue;
            groupByParam = groupByParam + ((TngOrderNamed)jGroupBy.getSelectedItem()).getOrder() + ",";
        }
        if (TngUtilities.isEmpty(groupByParam)) {
            return null;
        }
        return TngUtilities.strCutEnd(groupByParam, 1);
    }

    public void writeParams(TngReportParams reportParams) {
        this.jNote.setString(reportParams.note);
        this.writeParamOrderBy(reportParams);
        this.writeParamGroupBy(reportParams);
    }

    private void writeParamOrderBy(TngReportParams reportParams) {
        if (!this.jOrderBy.isEnabled()) {
            return;
        }
        int index = TngOrderNamed.find(this.definitionOrderBy.toArray(new TngOrderNamed[this.definitionOrderBy.size()]), reportParams.orderBy);
        if (index < 0 || index > this.jOrderBy.getItemCount() - 1) {
            index = 0;
        }
        this.jOrderBy.setSelectedIndex(index);
        this.jOrderReverse.setSelected(reportParams.orderByReversed);
    }

    private void writeParamGroupBy(TngReportParams reportParams) {
        String[] groupByParams = TngUtilities.strTokenizeNotNull(reportParams.groupBy, ',');
        for (int i2 = 0; i2 < this.jGroupBys.length; ++i2) {
            int index = 0;
            TngComboBox groupByCombo = this.jGroupBys[i2];
            if (groupByParams.length > i2) {
                String groupByParam = groupByParams[i2].trim();
                for (int j2 = 1; j2 < groupByCombo.getItemCount(); ++j2) {
                    TngOrderNamed o2 = (TngOrderNamed)groupByCombo.getItemAt(j2);
                    if (!o2.getOrder().equals(groupByParam)) continue;
                    index = j2;
                }
            }
            groupByCombo.setSelectedIndex(index);
        }
    }
}

