/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import tangram.library.Nat;
import tangram.report.TngReportFile;
import tangram.report.visual.TngReportParams;
import tangram.swing.TngSwing;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.component.field.TngFieldInteger;
import tangram.swing.panel.TngPanel;

public class TngReportPanelPrinter
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngComboBox jFiles = new TngComboBox();
    private TngFieldInteger jCopies = new TngFieldInteger();
    private final List<TngReportFile> reportFiles = new ArrayList<TngReportFile>();

    public TngReportPanelPrinter() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(650, 74));
        this.setTitle(Nat.x("Nastavenia tla\u010de"));
        this.setLayout(this.gridBagLayout1);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel1.setText(Nat.x("Tla\u010dov\u00e1 zostava"));
        this.jLabel2.setText(Nat.x("Po\u010det v\u00fdtla\u010dkov"));
        this.jFiles.setRenderer(new TngReportFileRenderer());
        this.jCopies.setValueCanNull(false);
        this.jCopies.setInteger(1);
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 10), 0, 0));
        this.add((Component)this.jFiles, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jCopies, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 50, 0));
        TngSwing.setOptimalHeight(this);
    }

    public List<TngReportFile> getReportFiles() {
        return this.reportFiles;
    }

    public void init(String reportPrefix) {
        this.loadReports(reportPrefix);
        this.populateReports();
    }

    private void loadReports(String reportPrefix) {
        try {
            this.reportFiles.clear();
            this.reportFiles.addAll(TngReportFile.getFiles(reportPrefix, System.getProperty("user.dir")));
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void populateReports() {
        this.jFiles.removeAllItems();
        if (this.reportFiles.size() == 0) {
            TngSwing.msgWarning(Nat.x("Nie s\u00fa definovan\u00e9 \u017eiadne tla\u010dov\u00e9 zostavy"));
        } else {
            for (TngReportFile reportFile : this.reportFiles) {
                this.jFiles.addItem(reportFile);
            }
            this.jFiles.setSelectedIndex(0);
        }
    }

    public void readParams(TngReportParams reportParams) {
        reportParams.reportFile = (TngReportFile)this.jFiles.getSelectedItem();
        reportParams.copies = this.jCopies.getIntegerDef(1);
    }

    public void writeParams(TngReportParams reportParams) {
        this.jFiles.setSelectedItem(reportParams.reportFile);
        this.jCopies.setInteger(reportParams.copies);
    }

    private static class TngReportFileRenderer
    extends TngListRendererCell {
        private TngReportFileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            TngReportFile item = (TngReportFile)value;
            this.setText(item == null ? null : item.getTitle());
            return this;
        }
    }
}

