/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import tangram.library.Nat;
import tangram.report.variant.TngReportVariant;
import tangram.report.visual.TngReportPanelVariantForm;
import tangram.report.visual.TngReportParams;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.TngList;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.component.button.TngButton;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;

public class TngReportPanelVariantWizard
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private TngScrollPane jScrollPane2 = new TngScrollPane();
    private TngList jVariants = new TngList();
    private TngButton jTop = new TngButton();
    private TngButton jUp = new TngButton();
    private TngButton jDown = new TngButton();
    private TngButton jBottom = new TngButton();
    private TngButton jEdit = new TngButton();
    private TngButton jDelete = new TngButton();
    private TngButton jAZ = new TngButton();
    private TngButton jZA = new TngButton();
    private String actVariantName;
    private TngReportParams reportParams;
    private DefaultListModel mdVariants = new DefaultListModel();

    public TngReportPanelVariantWizard() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setData(List<TngReportVariant> variants, TngReportParams reportParams) {
        this.reportParams = reportParams;
        this.actVariantName = reportParams.variant.name;
        this.setVariants(variants);
        this.selectAndScroll(this.jVariants, TngReportVariant.getVariantIndexByName(variants, this.actVariantName));
    }

    @Override
    public void doValidate(TngValidationError errors) {
        if (this.mdVariants.size() == 0) {
            errors.addError(this.jVariants, Nat.x("Nezvolili ste \u017eiadne ulo\u017een\u00e9 parametre"));
        }
    }

    @Override
    public boolean doSave() throws Exception {
        this.actVariantName = ((TngReportVariant)this.jVariants.getSelectedValue()).name;
        return true;
    }

    public void readVariant() {
        for (int i2 = 0; i2 < this.mdVariants.size(); ++i2) {
            TngReportVariant variant = (TngReportVariant)this.mdVariants.get(i2);
            if (!variant.name.equals(this.actVariantName)) continue;
            this.reportParams.variant = variant;
        }
    }

    public ArrayList<TngReportVariant> getVariants() {
        ArrayList<TngReportVariant> variants = new ArrayList<TngReportVariant>();
        for (int i2 = 0; i2 < this.mdVariants.size(); ++i2) {
            variants.add((TngReportVariant)this.mdVariants.get(i2));
        }
        return variants;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(635, 453));
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(330, 280));
        this.setSize(new Dimension(353, 252));
        this.setTitle(Nat.x("Ulo\u017een\u00e9 parametre"));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 130));
        this.jVariants.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngReportPanelVariantWizard.this.jOrder_mouseClicked(e2);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.jTop.setMargin(new Insets(0, 0, 0, 0));
        this.jTop.setToolTipText(Nat.x("Na za\u010diatok"));
        this.jTop.setText(Nat.nox("M"));
        this.jTop.setFocusable(false);
        this.jTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.jFirst_actionPerformed(e2);
            }
        });
        this.jUp.setMargin(new Insets(0, 0, 0, 0));
        this.jUp.setToolTipText(Nat.x("Posun\u00fa\u0165 hore"));
        this.jUp.setText(Nat.nox("M"));
        this.jUp.setFocusable(false);
        this.jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.jUp_actionPerformed(e2);
            }
        });
        this.jDown.setMargin(new Insets(0, 0, 0, 0));
        this.jDown.setToolTipText(Nat.x("Posun\u00fa\u0165 dole"));
        this.jDown.setText(Nat.nox("M"));
        this.jDown.setFocusable(false);
        this.jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.jDown_actionPerformed(e2);
            }
        });
        this.jBottom.setMargin(new Insets(0, 0, 0, 0));
        this.jBottom.setToolTipText(Nat.x("Na koniec"));
        this.jBottom.setText(Nat.nox("M"));
        this.jBottom.setFocusable(false);
        this.jBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.jLast_actionPerformed(e2);
            }
        });
        this.jEdit.setMargin(new Insets(0, 0, 0, 0));
        this.jEdit.setToolTipText(Nat.x("Upravi\u0165"));
        this.jEdit.setText(Nat.nox("M"));
        this.jEdit.setFocusable(false);
        this.jEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.variantEdit();
            }
        });
        this.jDelete.setMargin(new Insets(0, 0, 0, 0));
        this.jDelete.setToolTipText(Nat.x("Vymaza\u0165"));
        this.jDelete.setText(Nat.nox("M"));
        this.jDelete.setFocusable(false);
        this.jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.variantDelete();
            }
        });
        this.jAZ.setMargin(new Insets(0, 0, 0, 0));
        this.jAZ.setToolTipText(Nat.x("Usporiada\u0165 pod\u013ea abecedy vzostupne"));
        this.jAZ.setText(Nat.nox("A-Z"));
        this.jAZ.setFocusable(false);
        this.jAZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.sort(true);
            }
        });
        this.jZA.setMargin(new Insets(0, 0, 0, 0));
        this.jZA.setToolTipText(Nat.x("Usporiada\u0165 pod\u013ea abecedy zostupne"));
        this.jZA.setText(Nat.nox("Z-A"));
        this.jZA.setFocusable(false);
        this.jZA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportPanelVariantWizard.this.sort(false);
            }
        });
        this.jScrollPane2.getViewport().add((Component)this.jVariants, null);
        this.add((Component)this.jScrollPane2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.jPanel2.add((Component)this.jTop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jUp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jBottom, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jAZ, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jZA, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jEdit, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jDelete, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.changeButton(this.jTop, "arrow_top.png");
        this.changeButton(this.jUp, "arrow_up.png");
        this.changeButton(this.jDown, "arrow_down.png");
        this.changeButton(this.jBottom, "arrow_bottom.png");
        this.changeButton(this.jEdit, "wizard.png");
        this.changeButton(this.jDelete, "cancel.png");
        this.jVariants.setCellRenderer(new VariantCellRenderer());
        this.jVariants.setSelectionMode(0);
    }

    private void changeButton(TngButton c2, String icon) {
        c2.setIcon(TngIcon.getIcon(icon));
        c2.setText(null);
    }

    private void setVariants(List<TngReportVariant> variants) {
        this.jVariants.setModel(this.mdVariants);
        this.mdVariants.clear();
        if (variants != null && variants.size() != 0) {
            for (TngReportVariant v2 : variants) {
                this.mdVariants.addElement(v2);
            }
        }
        this.selectAndScroll(this.jVariants, 0);
    }

    private void orderShiftSelectedUp(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jVariants.getMinSelectionIndex();
        int b2 = this.jVariants.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (a2 == 0) {
            return;
        }
        if (shift < 0) {
            shift = a2;
        }
        for (int i2 = a2; i2 <= b2; ++i2) {
            if (!this.jVariants.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdVariants, i2, i2 - shift);
            this.jVariants.addSelectionInterval(i2 - shift, i2 - shift);
        }
        int v2 = a2 - shift - 1;
        if (v2 < 0) {
            v2 = 0;
        }
        this.jVariants.ensureIndexIsVisible(v2);
    }

    private void orderShiftSelectedDown(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jVariants.getMinSelectionIndex();
        int b2 = this.jVariants.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (b2 == this.mdVariants.getSize() - 1) {
            return;
        }
        if (shift < 0) {
            shift = this.mdVariants.getSize() - b2 - 1;
        }
        for (int i2 = b2; i2 >= a2; --i2) {
            if (!this.jVariants.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdVariants, i2, i2 + shift);
            this.jVariants.addSelectionInterval(i2 + shift, i2 + shift);
        }
        int v2 = b2 + shift + 1;
        if (v2 >= this.mdVariants.getSize()) {
            v2 = this.mdVariants.getSize() - 1;
        }
        this.jVariants.ensureIndexIsVisible(v2);
    }

    private void moveElement(DefaultListModel m2, int from, int to) {
        if (m2 == null || from == to) {
            return;
        }
        if (from < 0 || to < 0 || from >= m2.getSize() || to >= m2.getSize()) {
            return;
        }
        Object o2 = m2.getElementAt(from);
        m2.removeElementAt(from);
        m2.insertElementAt(o2, to);
    }

    private void selectAndScroll(TngList list, int index) {
        if (index <= 0) {
            index = 0;
        }
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    private void variantEdit() {
        if (this.mdVariants.size() == 0) {
            return;
        }
        TngReportPanelVariantForm form = new TngReportPanelVariantForm();
        int index = this.jVariants.getSelectedIndex();
        TngReportVariant o2 = (TngReportVariant)this.mdVariants.getElementAt(index);
        form.setVariant(o2);
        boolean actFlag = this.actVariantName.equals(o2.name);
        if (TngDlg.runModal(form)) {
            TngReportVariant editVariant = form.getVariant();
            this.mdVariants.set(index, editVariant);
            this.selectAndScroll(this.jVariants, index);
            if (actFlag) {
                this.actVariantName = editVariant.name;
            }
        }
    }

    private void variantDelete() {
        if (this.mdVariants.size() == 0) {
            return;
        }
        int index = this.jVariants.getSelectedIndex();
        TngReportVariant o2 = (TngReportVariant)this.mdVariants.getElementAt(index);
        if (TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te vymaza\u0165 ulo\u017een\u00e9 parametre '%1'?", o2.name))) {
            this.mdVariants.removeElementAt(index);
            this.selectAndScroll(this.jVariants, 0);
        }
    }

    private void sort(boolean asc) {
        int i2;
        if (this.mdVariants.size() <= 1) {
            return;
        }
        int numItems = this.mdVariants.getSize();
        TngReportVariant[] a2 = new TngReportVariant[numItems];
        for (i2 = 0; i2 < numItems; ++i2) {
            a2[i2] = (TngReportVariant)this.mdVariants.getElementAt(i2);
        }
        this.sortArray(Collator.getInstance(), a2, asc);
        for (i2 = 0; i2 < numItems; ++i2) {
            this.mdVariants.setElementAt(a2[i2], i2);
        }
    }

    private void sortArray(Collator collator, TngReportVariant[] variantsArray, boolean asc) {
        for (int i2 = 0; i2 < variantsArray.length; ++i2) {
            for (int j2 = i2 + 1; j2 < variantsArray.length; ++j2) {
                int compare = asc ? collator.compare(variantsArray[i2].name, variantsArray[j2].name) : collator.compare(variantsArray[j2].name, variantsArray[i2].name);
                if (compare <= 0) continue;
                TngReportVariant tmp = variantsArray[i2];
                variantsArray[i2] = variantsArray[j2];
                variantsArray[j2] = tmp;
            }
        }
    }

    private void jOrder_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            this.variantEdit();
        }
    }

    private void jFirst_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(-1);
    }

    private void jUp_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(1);
    }

    private void jDown_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(1);
    }

    private void jLast_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(-1);
    }

    private static class VariantCellRenderer
    extends TngListRendererCell {
        private VariantCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            TngReportVariant o2 = (TngReportVariant)value;
            this.setText(o2.name);
            return this;
        }
    }
}

